/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.classify.ConfusionMatrix;
import com.aliasi.lm.CompiledNGramProcessLM;
import com.aliasi.spell.CompiledSpellChecker;
import com.aliasi.spell.SpellChecker;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SpellEvaluator {
    private final SpellChecker mSpellChecker;
    private final List<String> mTextList = new ArrayList<String>();
    private final List<String> mCorrectTextList = new ArrayList<String>();
    private final List<String> mSuggestionList = new ArrayList<String>();
    private String mLastCaseReport = "No cases added yet.";
    private int mUserCorrectSystemWrongSuggestion = 0;
    private int mUserCorrectSystemNoSuggestion = 0;
    private int mUserErrorSystemNoSuggestion = 0;
    private int mUserErrorSystemCorrect = 0;
    private int mUserErrorSystemWrongSuggestion = 0;
    private final ObjectToCounterMap<String> mTokenCounter;
    static final DecimalFormat LP_FORMAT = new DecimalFormat("#0.0");
    static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("##0.0");

    public SpellEvaluator(SpellChecker checker) {
        this(checker, null);
    }

    public SpellEvaluator(SpellChecker checker, ObjectToCounterMap<String> tokenCounter) {
        this.mSpellChecker = checker;
        this.mTokenCounter = tokenCounter;
    }

    public void addCase(String text, String correctText) {
        String normalizedText = this.normalize(text);
        String normalizedCorrectText = this.normalize(correctText);
        String suggestion = this.mSpellChecker.didYouMean(text);
        String normalizedSuggestion = suggestion == null ? normalizedText : this.normalize(suggestion);
        this.mTextList.add(normalizedText);
        this.mCorrectTextList.add(normalizedCorrectText);
        this.mSuggestionList.add(normalizedSuggestion);
        String resultDescription = null;
        if (normalizedText.equals(normalizedCorrectText)) {
            resultDescription = "user correct, ";
            if (normalizedText.equals(normalizedSuggestion)) {
                resultDescription = String.valueOf(resultDescription) + "spell check wrong suggestion (FP)";
                ++this.mUserCorrectSystemWrongSuggestion;
            } else {
                resultDescription = String.valueOf(resultDescription) + "spell check no suggestion (TN)";
                ++this.mUserCorrectSystemNoSuggestion;
            }
        } else {
            resultDescription = "user incorrect, ";
            if (normalizedText.equals(normalizedSuggestion)) {
                resultDescription = String.valueOf(resultDescription) + "spell check no suggestion (FN)";
                ++this.mUserErrorSystemNoSuggestion;
            } else if (normalizedCorrectText.equals(normalizedSuggestion)) {
                resultDescription = String.valueOf(resultDescription) + "spell check correct (TP)";
                ++this.mUserErrorSystemCorrect;
            } else {
                resultDescription = String.valueOf(resultDescription) + "spell check wrong suggestion (FP,FN)";
                ++this.mUserErrorSystemWrongSuggestion;
            }
        }
        StringBuilder sb = new StringBuilder();
        this.report(sb, "input", normalizedText);
        sb.append("\n");
        this.report(sb, "correct", normalizedCorrectText);
        sb.append("\n");
        this.report(sb, "suggest", normalizedSuggestion);
        sb.append("\n");
        this.mLastCaseReport = sb.toString();
    }

    void report(StringBuilder sb, String msg, String text) {
        sb.append(String.valueOf(msg) + "=|" + text + "|");
        if (!(this.mSpellChecker instanceof CompiledSpellChecker)) {
            return;
        }
        CompiledSpellChecker checker = (CompiledSpellChecker)this.mSpellChecker;
        CompiledNGramProcessLM lm = checker.languageModel();
        double estimate = lm.log2Estimate(" " + text + " ") - lm.log2Estimate(" ");
        sb.append(" log2 p=" + SpellEvaluator.lpFormat(estimate));
        TokenizerFactory tf = checker.tokenizerFactory();
        char[] cs = text.toCharArray();
        Tokenizer tokenizer = tf.tokenizer(cs, 0, cs.length);
        String[] tokens = tokenizer.tokenize();
        Set<String> tokenSet = checker.tokenSet();
        int i = 0;
        while (i < tokens.length) {
            sb.append(" ");
            sb.append(tokens[i]);
            sb.append("[");
            if (this.mTokenCounter == null) {
                sb.append(tokenSet.contains(tokens[i]) ? "+" : "-");
            } else {
                sb.append(this.mTokenCounter.getCount(tokens[i]));
            }
            sb.append("]");
            ++i;
        }
    }

    static String lpFormat(double x) {
        return LP_FORMAT.format(x);
    }

    public String toString() {
        int userErrors = this.mUserErrorSystemWrongSuggestion + this.mUserErrorSystemCorrect + this.mUserErrorSystemNoSuggestion;
        int userCorrect = this.mUserCorrectSystemWrongSuggestion + this.mUserCorrectSystemNoSuggestion;
        int total = userErrors + userCorrect;
        StringBuilder sb = new StringBuilder();
        sb.append("EVALUATION\n");
        SpellEvaluator.addReport(sb, "User Error", userErrors, total);
        SpellEvaluator.addReport(sb, "     System Correct", this.mUserErrorSystemCorrect, userErrors);
        SpellEvaluator.addReport(sb, "     System Error", this.mUserErrorSystemWrongSuggestion, userErrors);
        SpellEvaluator.addReport(sb, "     System No Suggestion", this.mUserErrorSystemNoSuggestion, userErrors);
        SpellEvaluator.addReport(sb, "User Correct", userCorrect, total);
        SpellEvaluator.addReport(sb, "     System Error", this.mUserCorrectSystemWrongSuggestion, userCorrect);
        SpellEvaluator.addReport(sb, "     System No Suggestion", this.mUserCorrectSystemNoSuggestion, userCorrect);
        sb.append("SPELL CHECKER toString()\n");
        sb.append(this.mSpellChecker);
        return sb.toString();
    }

    static void addReport(StringBuilder sb, String msg, int correct, int total) {
        sb.append(msg);
        sb.append(": ");
        sb.append(correct);
        sb.append(" [");
        double percentage = total > 0 ? 100.0 * (double)correct / (double)total : 0.0;
        sb.append(PERCENT_FORMAT.format(percentage));
        sb.append("%]\n");
    }

    public String[][] userCorrectSystemNoSuggestion() {
        return this.extract(true, true, true);
    }

    public String[][] userCorrectSystemWrongSuggestion() {
        return this.extract(true, false, false);
    }

    public String[][] userErrorSystemCorrect() {
        return this.extract(false, true, false);
    }

    public String[][] userErrorSystemWrongSuggestion() {
        return this.extract(false, false, false);
    }

    public String[][] userErrorSystemNoSuggestion() {
        return this.extract(false, false, true);
    }

    String[][] extract(boolean textEqualsCorrect, boolean correctEqualsSuggestion, boolean textEqualsSuggestion) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int i = 0;
        while (i < this.mSuggestionList.size()) {
            String text = this.mTextList.get(i).toString();
            String correct = this.mCorrectTextList.get(i).toString();
            String suggestion = this.mSuggestionList.get(i).toString();
            if (text.equals(correct) == textEqualsCorrect && correct.equals(suggestion) == correctEqualsSuggestion && text.equals(suggestion) == textEqualsSuggestion) {
                result.add(new String[]{text, correct, suggestion});
            }
            ++i;
        }
        return (String[][])result.toArray((T[])Strings.EMPTY_STRING_2D_ARRAY);
    }

    public String getLastCaseReport() {
        return this.mLastCaseReport;
    }

    public ConfusionMatrix confusionMatrix() {
        int tn = this.mUserCorrectSystemNoSuggestion;
        int tp = this.mUserErrorSystemCorrect;
        int fn = this.mUserErrorSystemNoSuggestion + this.mUserErrorSystemWrongSuggestion;
        int fp = this.mUserCorrectSystemWrongSuggestion;
        return new ConfusionMatrix(new String[]{"correct", "misspelled"}, new int[][]{{tp, fp}, {fn, tn}});
    }

    public String normalize(String text) {
        return text;
    }
}

