/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.AbstractDiscreteDistribution;

public class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final double[] mEstimates;

    public ZipfDistribution(int numOutcomes) {
        if (numOutcomes <= 0) {
            String msg = "Number of outcomes must be postive. Found numOutcomes=" + numOutcomes;
            throw new IllegalArgumentException(msg);
        }
        this.mEstimates = ZipfDistribution.zipfDistribution(numOutcomes);
    }

    @Override
    public long minOutcome() {
        return 1L;
    }

    @Override
    public long maxOutcome() {
        return this.mEstimates.length;
    }

    public int numOutcomes() {
        return this.mEstimates.length;
    }

    @Override
    public double probability(long rank) {
        if (rank <= 0L || rank > (long)this.mEstimates.length) {
            return 0.0;
        }
        return this.mEstimates[(int)rank - 1];
    }

    public static double[] zipfDistribution(int numOutcomes) {
        double[] ratio = new double[numOutcomes];
        int i = 1;
        while (i <= numOutcomes) {
            ratio[i - 1] = 1.0 / (double)i;
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < ratio.length) {
            sum += ratio[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < ratio.length) {
            int n = i2++;
            ratio[n] = ratio[n] / sum;
        }
        return ratio;
    }
}

