/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.suffixarray;

import com.aliasi.tokenizer.Tokenization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TokenSuffixArray {
    private final Tokenization mTokenization;
    private final int[] mSuffixArray;
    private final String mDocumentBoundaryToken;
    private final int mMaxSuffixLength;
    public static final String DEFAULT_DOCUMENT_BOUNDARY_TOKEN = "\u0000";

    public TokenSuffixArray(Tokenization tokenization) {
        this(tokenization, Integer.MAX_VALUE);
    }

    public TokenSuffixArray(Tokenization tokenization, int maxSuffixLength) {
        this(tokenization, maxSuffixLength, DEFAULT_DOCUMENT_BOUNDARY_TOKEN);
    }

    public TokenSuffixArray(Tokenization tokenization, int maxSuffixLength, String documentBoundaryToken) {
        this.mTokenization = tokenization;
        this.mDocumentBoundaryToken = documentBoundaryToken;
        this.mMaxSuffixLength = maxSuffixLength;
        Integer[] is = new Integer[tokenization.numTokens()];
        int i = 0;
        while (i < is.length) {
            is[i] = i;
            ++i;
        }
        Arrays.sort(is, new TokenIndexComparator());
        int[] suffixArray = new int[is.length];
        int i2 = 0;
        while (i2 < is.length) {
            suffixArray[i2] = is[i2];
            ++i2;
        }
        this.mSuffixArray = suffixArray;
    }

    public String documentBoundaryToken() {
        return this.mDocumentBoundaryToken;
    }

    public int maxSuffixLength() {
        return this.mMaxSuffixLength;
    }

    public Tokenization tokenization() {
        return this.mTokenization;
    }

    public int suffixArray(int idx) {
        return this.mSuffixArray[idx];
    }

    public int suffixArrayLength() {
        return this.mSuffixArray.length;
    }

    public String substring(int idx, int maxTokens) {
        int start = this.suffixArray(idx);
        int end = (int)Math.min((long)start + (long)maxTokens, (long)this.mTokenization.numTokens());
        int text_start = this.mTokenization.tokenStart(start);
        int text_end = this.mTokenization.tokenEnd(end - 1);
        return this.mTokenization.text().substring(text_start, text_end);
    }

    public List<int[]> prefixMatches(int minMatchLength) {
        ArrayList<int[]> matches = new ArrayList<int[]>();
        int i = 0;
        while (i < this.mSuffixArray.length) {
            int j = this.suffixesMatchTo(i, minMatchLength, this.mTokenization.tokenList());
            if (i + 1 != j) {
                matches.add(new int[]{i, j});
                i = j;
                continue;
            }
            ++i;
        }
        return matches;
    }

    private int suffixesMatchTo(int i, int minMatchLength, List<String> tokens) {
        int index1 = this.mSuffixArray[i];
        int j = i + 1;
        while (j < this.mSuffixArray.length) {
            int index2 = this.mSuffixArray[j];
            if (!this.matchTokens(index1, index2, minMatchLength, tokens)) break;
            ++j;
        }
        return j;
    }

    private boolean matchTokens(int index1, int index2, int minMatches, List<String> tokens) {
        if (index1 + minMatches > this.mSuffixArray.length) {
            return false;
        }
        if (index2 + minMatches > this.mSuffixArray.length) {
            return false;
        }
        int k = 0;
        while (k < minMatches) {
            String tok1 = tokens.get(index1 + k);
            if (tok1.equals(this.mDocumentBoundaryToken)) {
                return false;
            }
            String tok2 = tokens.get(index2 + k);
            if (tok2.equals(this.mDocumentBoundaryToken)) {
                return false;
            }
            if (!tokens.get(index1 + k).equals(tokens.get(index2 + k))) {
                return false;
            }
            ++k;
        }
        return true;
    }

    class TokenIndexComparator
    implements Comparator<Integer> {
        TokenIndexComparator() {
        }

        @Override
        public int compare(Integer i, Integer j) {
            List<String> tokens = TokenSuffixArray.this.mTokenization.tokenList();
            int m = i;
            int n = j;
            int k = 0;
            while (k < TokenSuffixArray.this.mMaxSuffixLength) {
                if (m == tokens.size() || tokens.get(m).equals(TokenSuffixArray.this.mDocumentBoundaryToken)) {
                    if (n == tokens.size() || tokens.get(n).equals(TokenSuffixArray.this.mDocumentBoundaryToken)) {
                        return 0;
                    }
                    return -1;
                }
                if (n == tokens.size() || tokens.get(n).equals(TokenSuffixArray.this.mDocumentBoundaryToken)) {
                    return 1;
                }
                int c = tokens.get(m).compareTo(tokens.get(n));
                if (c != 0) {
                    return c;
                }
                ++m;
                ++n;
                ++k;
            }
            return 0;
        }
    }
}

