/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.cluster.CompleteLinkClusterer;
import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.test.unit.cluster.SingleLinkClustererTest;
import com.aliasi.util.Distance;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class CompleteLinkClustererTest {
    @Test
    public void testBoundaries() {
        CompleteLinkClusterer<String> clusterer = new CompleteLinkClusterer<String>(SingleLinkClustererTest.TEST_DISTANCE);
        HashSet elts0 = new HashSet();
        Set clusters = clusterer.cluster(elts0);
        Assert.assertEquals((int)0, (int)clusters.size());
        HashSet<String> elts1 = new HashSet<String>();
        elts1.add("A");
        HashSet<HashSet<String>> clustering = new HashSet<HashSet<String>>();
        clustering.add(elts1);
        Assert.assertEquals(clustering, clusterer.cluster(elts1));
        Dendrogram<String> dendro1 = clusterer.hierarchicalCluster(elts1);
        Assert.assertTrue((boolean)(dendro1 instanceof LeafDendrogram));
        Assert.assertEquals(elts1, dendro1.memberSet());
        Assert.assertEquals((double)0.0, (double)dendro1.score(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompleteLinkExc() {
        CompleteLinkClusterer<String> clusterer = new CompleteLinkClusterer<String>(SingleLinkClustererTest.TEST_DISTANCE);
        HashSet elts0 = new HashSet();
        clusterer.hierarchicalCluster(elts0);
    }

    @Test
    public void testOne() {
        CompleteLinkClusterer<String> clusterer = new CompleteLinkClusterer<String>(SingleLinkClustererTest.TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        HashSet<String> a = new HashSet<String>();
        a.add("A");
        HashSet<String> b = new HashSet<String>();
        b.add("B");
        HashSet<String> c = new HashSet<String>();
        c.add("C");
        HashSet<String> d = new HashSet<String>();
        d.add("D");
        HashSet<String> e = new HashSet<String>();
        e.add("E");
        HashSet<String> ab = new HashSet<String>();
        ab.addAll(a);
        ab.addAll(b);
        HashSet<String> abc = new HashSet<String>();
        abc.addAll(ab);
        abc.addAll(c);
        HashSet<String> de = new HashSet<String>();
        de.addAll(d);
        de.addAll(e);
        HashSet<String> abcde = new HashSet<String>();
        abcde.addAll(abc);
        abcde.addAll(de);
        Assert.assertEquals(abcde, dendro.memberSet());
        HashSet<HashSet<String>> p1 = new HashSet<HashSet<String>>();
        p1.add(abcde);
        Assert.assertEquals(p1, dendro.partitionK(1));
        HashSet<HashSet<String>> p2 = new HashSet<HashSet<String>>();
        p2.add(abc);
        p2.add(de);
        Assert.assertEquals(p2, dendro.partitionK(2));
        HashSet<HashSet<String>> p3 = new HashSet<HashSet<String>>();
        p3.add(abc);
        p3.add(d);
        p3.add(e);
        Assert.assertEquals(p3, dendro.partitionK(3));
        HashSet<HashSet<String>> p4 = new HashSet<HashSet<String>>();
        p4.add(ab);
        p4.add(c);
        p4.add(d);
        p4.add(e);
        Assert.assertEquals(p4, dendro.partitionK(4));
        HashSet<HashSet<String>> p5 = new HashSet<HashSet<String>>();
        p5.add(a);
        p5.add(b);
        p5.add(c);
        p5.add(d);
        p5.add(e);
        Assert.assertEquals(p5, dendro.partitionK(5));
        Assert.assertEquals((String)"ouch", (double)9.0, (double)dendro.score(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompleteExc1() {
        CompleteLinkClusterer<String> clusterer = new CompleteLinkClusterer<String>(SingleLinkClustererTest.TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        dendro.partitionK(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompleteExc2() {
        CompleteLinkClusterer<String> clusterer = new CompleteLinkClusterer<String>(SingleLinkClustererTest.TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        dendro.partitionK(6);
    }

    @Test
    public void testSix() {
        Integer[] ints = new Integer[10];
        int i = 0;
        while (i < ints.length) {
            ints[i] = i;
            ++i;
        }
        SingleLinkClustererTest.FixedDistance<Integer> dist = new SingleLinkClustererTest.FixedDistance<Integer>();
        double[][] vals = new double[][]{{13.0}, {21.0, 9.0}, {18.0, 19.0, 22.0}, {4.0, 15.0, 20.0, 3.0}, {8.0, 14.0, 12.0, 23.0, 5.0}, {7.0, 10.0, 11.0, 27.0, 24.0, 6.0}, {28.0, 16.0, 17.0, 1.0, 2.0, 25.0, 26.0}};
        int i2 = 0;
        while (i2 < vals.length) {
            int j = 0;
            while (j < vals[i2].length) {
                dist.setVal(ints[i2 + 1], ints[j], vals[i2][j]);
                ++j;
            }
            ++i2;
        }
        HashSet<Integer> elts = new HashSet<Integer>();
        int i3 = 0;
        while (i3 < 8) {
            elts.add(ints[i3]);
            ++i3;
        }
        CompleteLinkClusterer<Integer> clusterer = new CompleteLinkClusterer<Integer>(dist);
        Dendrogram dendrogram = clusterer.hierarchicalCluster(elts);
        HashSet<Integer> dtrs1 = new HashSet<Integer>();
        dtrs1.add(ints[0]);
        dtrs1.add(ints[5]);
        dtrs1.add(ints[6]);
        dtrs1.add(ints[1]);
        dtrs1.add(ints[2]);
        HashSet<Integer> dtrs2 = new HashSet<Integer>();
        dtrs2.add(ints[3]);
        dtrs2.add(ints[7]);
        dtrs2.add(ints[4]);
        Assert.assertTrue((boolean)(dendrogram instanceof LinkDendrogram));
        LinkDendrogram linkDendro = (LinkDendrogram)dendrogram;
        Dendrogram dendro1 = linkDendro.dendrogram1();
        Dendrogram dendro2 = linkDendro.dendrogram2();
        Assert.assertTrue((dendro1.memberSet().equals(dtrs1) && dendro2.memberSet().equals(dtrs2) || dendro2.memberSet().equals(dtrs1) && dendro1.memberSet().equals(dtrs2) ? 1 : 0) != 0);
    }

    @Test
    public void testPartition() {
        double maxDistance = 0.05;
        while (maxDistance < 7.0) {
            this.assertTestPartitionAt(maxDistance);
            maxDistance += 0.5;
        }
    }

    void assertTestPartitionAt(double maxDistance) {
        HashSet<Double> input = new HashSet<Double>();
        input.add(1.0);
        input.add(2.0);
        input.add(3.0);
        input.add(4.0);
        input.add(5.0);
        input.add(5.1);
        input.add(5.2);
        input.add(5.3);
        input.add(5.4);
        Distance<Double> distance = new Distance<Double>(){

            @Override
            public double distance(Double a1, Double a2) {
                return Math.abs(a1 - a2);
            }
        };
        CompleteLinkClusterer<Double> clusterer = new CompleteLinkClusterer<Double>(maxDistance, distance);
        Set clusters = clusterer.cluster(input);
        int size = 0;
        for (Set cluster : clusters) {
            size += cluster.size();
        }
        Assert.assertEquals((int)input.size(), (int)size);
    }
}

