/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.coref;

import com.aliasi.coref.EnglishMentionFactory;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class EnglishMentionFactoryTest {
    @Test
    public void testOne() {
        EnglishMentionFactory factory = new EnglishMentionFactory();
        Mention fm1 = factory.create("Mr. John Smith", "PERSON");
        junit.framework.Assert.assertEquals((String)"Mr. John Smith", (String)fm1.phrase());
        junit.framework.Assert.assertEquals((String)"PERSON", (String)fm1.entityType());
        HashSet<String> honorifics = new HashSet<String>();
        honorifics.add("mr");
        junit.framework.Assert.assertEquals(honorifics, fm1.honorifics());
        junit.framework.Assert.assertFalse((boolean)fm1.isPronominal());
        Assert.assertArrayEquals((Object[])new String[]{"john", "smith"}, (Object[])fm1.normalTokens());
        MentionChain fc1 = factory.promote(fm1, 7);
        HashSet<Mention> mentions = new HashSet<Mention>();
        mentions.add(fm1);
        junit.framework.Assert.assertEquals(mentions, fc1.mentions());
        junit.framework.Assert.assertEquals((String)"PERSON", (String)fc1.entityType());
        junit.framework.Assert.assertEquals(honorifics, fc1.honorifics());
        Mention fm2 = factory.create("He", "MALE_PRONOUN");
        junit.framework.Assert.assertEquals((String)"He", (String)fm2.phrase());
        junit.framework.Assert.assertEquals((String)"MALE_PRONOUN", (String)fm2.entityType());
        HashSet honorifics2 = new HashSet();
        junit.framework.Assert.assertEquals(honorifics2, fm2.honorifics());
        junit.framework.Assert.assertTrue((boolean)fm2.isPronominal());
        Assert.assertArrayEquals((Object[])new String[]{"he"}, (Object[])fm2.normalTokens());
        MentionChain fc2 = factory.promote(fm2, 19);
        HashSet<Mention> mentions2 = new HashSet<Mention>();
        mentions2.add(fm2);
        junit.framework.Assert.assertEquals(mentions2, fc2.mentions());
        junit.framework.Assert.assertEquals((String)"MALE_PRONOUN", (String)fc2.entityType());
        junit.framework.Assert.assertEquals(honorifics2, fc2.honorifics());
    }
}

