/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.dict;

import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.dict.ApproxDictionaryChunker;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.dict.TrieDictionary;
import com.aliasi.spell.FixedWeightEditDistance;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.Serializable;
import junit.framework.Assert;
import org.junit.Test;

public class ApproxDictionaryChunkerTest {
    @Test
    public void testGeneChunker() {
        TrieDictionary<String> trie = new TrieDictionary<String>();
        trie.addEntry(new DictionaryEntry<String>("SERPINA3", "GENE"));
        IndoEuropeanTokenizerFactory tokenizer = IndoEuropeanTokenizerFactory.INSTANCE;
        ApproxDictionaryChunker fuzzyDictMatcher = new ApproxDictionaryChunker(trie, tokenizer, ApproxDictionaryChunker.TT_DISTANCE, 500.0);
        String test1 = "serpin";
        Chunking chunking = fuzzyDictMatcher.chunk(test1);
        ChunkingImpl chunkingExpected = new ChunkingImpl(test1);
        chunkingExpected.add(ChunkFactory.createChunk(0, 6, "GENE", 260.0));
        Assert.assertEquals((Object)chunkingExpected, (Object)chunking);
    }

    @Test
    public void testDissimilarity() {
        TrieDictionary<String> dict = new TrieDictionary<String>();
        DictionaryEntry<String> entry1 = new DictionaryEntry<String>("ab", "X");
        DictionaryEntry<String> entry2 = new DictionaryEntry<String>("ab", "Y");
        DictionaryEntry<String> entry3 = new DictionaryEntry<String>("cd", "Z");
        dict.addEntry(entry1);
        dict.addEntry(entry2);
        dict.addEntry(entry3);
        IndoEuropeanTokenizerFactory tokenizerFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        double matchWeight = 0.0;
        double deleteWeight = -1.0;
        double insertWeight = -1.0;
        double substituteWeight = -1.0;
        double transposeWeight = Double.NEGATIVE_INFINITY;
        FixedWeightEditDistance editDistance = new FixedWeightEditDistance(matchWeight, deleteWeight, insertWeight, substituteWeight, transposeWeight);
        ApproxDictionaryChunker chunker = new ApproxDictionaryChunker(dict, tokenizerFactory, editDistance, 2.0);
        String test1 = "ab";
        ChunkingImpl chunking = new ChunkingImpl(test1);
        chunking.add(ChunkFactory.createChunk(0, 2, "X", 0.0));
        chunking.add(ChunkFactory.createChunk(0, 2, "Y", 0.0));
        chunking.add(ChunkFactory.createChunk(0, 2, "Z", 2.0));
        this.test(test1, chunker, chunking);
        String test2 = " ab xyzwf ";
        ChunkingImpl chunking2 = new ChunkingImpl(test2);
        chunking2.add(ChunkFactory.createChunk(1, 3, "X", 0.0));
        chunking2.add(ChunkFactory.createChunk(1, 3, "Y", 0.0));
        chunking2.add(ChunkFactory.createChunk(1, 3, "Z", 2.0));
        this.test(test2, chunker, chunking2);
        String test3 = " a c ";
        ChunkingImpl chunking3 = new ChunkingImpl(test3);
        chunking3.add(ChunkFactory.createChunk(1, 2, "X", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 2, "Y", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 2, "Z", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "X", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "Y", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "Z", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 4, "X", 2.0));
        chunking3.add(ChunkFactory.createChunk(1, 4, "Y", 2.0));
        this.test(test3, chunker, chunking3);
    }

    @Test
    public void testSimilarity() {
        TrieDictionary<String> dict = new TrieDictionary<String>();
        DictionaryEntry<String> entry1 = new DictionaryEntry<String>("ab", "X");
        DictionaryEntry<String> entry2 = new DictionaryEntry<String>("ab", "Y");
        DictionaryEntry<String> entry3 = new DictionaryEntry<String>("cd", "Z");
        dict.addEntry(entry1);
        dict.addEntry(entry2);
        dict.addEntry(entry3);
        IndoEuropeanTokenizerFactory tokenizerFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        double matchWeight = 0.0;
        double deleteWeight = -1.0;
        double insertWeight = -1.0;
        double substituteWeight = -1.0;
        double transposeWeight = Double.NEGATIVE_INFINITY;
        FixedWeightEditDistance editDistance = new FixedWeightEditDistance(matchWeight, deleteWeight, insertWeight, substituteWeight, transposeWeight);
        ApproxDictionaryChunker chunker = new ApproxDictionaryChunker(dict, tokenizerFactory, editDistance, 2.0);
        String test1 = "ab";
        ChunkingImpl chunking = new ChunkingImpl(test1);
        chunking.add(ChunkFactory.createChunk(0, 2, "X", 0.0));
        chunking.add(ChunkFactory.createChunk(0, 2, "Y", 0.0));
        chunking.add(ChunkFactory.createChunk(0, 2, "Z", 2.0));
        this.test(test1, chunker, chunking);
        String test2 = " ab xyzwf ";
        ChunkingImpl chunking2 = new ChunkingImpl(test2);
        chunking2.add(ChunkFactory.createChunk(1, 3, "X", 0.0));
        chunking2.add(ChunkFactory.createChunk(1, 3, "Y", 0.0));
        chunking2.add(ChunkFactory.createChunk(1, 3, "Z", 2.0));
        this.test(test2, chunker, chunking2);
        String test3 = " a c ";
        ChunkingImpl chunking3 = new ChunkingImpl(test3);
        chunking3.add(ChunkFactory.createChunk(1, 2, "X", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 2, "Y", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 2, "Z", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "X", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "Y", 2.0));
        chunking3.add(ChunkFactory.createChunk(3, 4, "Z", 1.0));
        chunking3.add(ChunkFactory.createChunk(1, 4, "X", 2.0));
        chunking3.add(ChunkFactory.createChunk(1, 4, "Y", 2.0));
        this.test(test3, chunker, chunking3);
    }

    void test(String test, Chunker chunker, Chunking expectedChunking) {
        char[] cs = test.toCharArray();
        Chunking chunking = chunker.chunk(cs, 0, cs.length);
        Assert.assertEquals((Object)expectedChunking, (Object)chunking);
        Chunker chunker2 = null;
        try {
            chunker2 = (Chunker)AbstractExternalizable.serializeDeserialize((Serializable)((Object)chunker));
        }
        catch (IOException e) {
            Assert.fail();
        }
        Chunking chunking2 = chunker2.chunk(cs, 0, cs.length);
        Assert.assertEquals((Object)expectedChunking, (Object)chunking2);
    }
}

