/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.UniformBoundaryLM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.junit.Test;

public class UniformBoundaryLMTest {
    @Test
    public void testBoundary() {
        UniformBoundaryLM lm = new UniformBoundaryLM(31);
        Assert.assertEquals((double)-5.0, (double)lm.log2Estimate(new char[0], 0, 0), (double)0.005);
        lm.train("foo");
        Assert.assertEquals((double)-5.0, (double)lm.log2Estimate(new char[0], 0, 0), (double)0.005);
        Assert.assertEquals((double)-10.0, (double)lm.log2Estimate(new char[]{'a'}, 0, 1), (double)0.005);
        Assert.assertEquals((double)-15.0, (double)lm.log2Estimate(new char[]{'a', 'b'}, 0, 2), (double)0.005);
    }

    public static Object compileRead(LanguageModel.Dynamic model) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        model.compileTo(objOut);
        byte[] modelBytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(modelBytes);
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        return objIn.readObject();
    }

    @Test
    public void testSerializable() throws ClassNotFoundException, IOException {
        UniformBoundaryLM lm = new UniformBoundaryLM(31);
        Object serDeser = UniformBoundaryLMTest.compileRead(lm);
        UniformBoundaryLM lmIO = (UniformBoundaryLM)serDeser;
        Assert.assertEquals((double)-5.0, (double)lmIO.log2Estimate(new char[0], 0, 0), (double)0.005);
        Assert.assertEquals((double)-10.0, (double)lmIO.log2Estimate(new char[]{'a'}, 0, 1), (double)0.005);
        Assert.assertEquals((double)-15.0, (double)lmIO.log2Estimate(new char[]{'a', 'b'}, 0, 2), (double)0.005);
    }

    @Test
    public void testExs() {
        try {
            new UniformBoundaryLM(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformBoundaryLM(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformBoundaryLM(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformBoundaryLM(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

