/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseMatrix;
import com.aliasi.matrix.Matrices;
import junit.framework.Assert;
import org.junit.Test;

public class MatricesTest {
    @Test
    public void testHasZeroDiagonal() {
        DenseMatrix m = new DenseMatrix(new double[][]{{0.0, 2.0}, {1.0, 0.0}});
        Assert.assertTrue((boolean)Matrices.hasZeroDiagonal(m));
        DenseMatrix m2 = new DenseMatrix(new double[][]{{0.0, 2.0, 3.0}, {1.0, 0.0, 4.0}});
        Assert.assertFalse((boolean)Matrices.hasZeroDiagonal(m2));
        DenseMatrix m3 = new DenseMatrix(new double[][]{{0.0, 2.0, 3.0}, {1.0, 0.0, 4.0}, {2.0, 0.0, 1.0}});
        Assert.assertFalse((boolean)Matrices.hasZeroDiagonal(m3));
    }

    @Test
    public void testNonNegative() {
        DenseMatrix m = new DenseMatrix(new double[][]{{1.0, 2.0}, {3.0, 5.0}});
        Assert.assertTrue((boolean)Matrices.isNonNegative(m));
        m.setValue(0, 0, -1.0);
        Assert.assertFalse((boolean)Matrices.isNonNegative(m));
        m.setValue(0, 0, 1.0);
        Assert.assertTrue((boolean)Matrices.isNonNegative(m));
        m.setValue(1, 0, Double.NaN);
        Assert.assertFalse((boolean)Matrices.isNonNegative(m));
        m.setValue(1, 0, 1.0);
        Assert.assertTrue((boolean)Matrices.isNonNegative(m));
        m.setValue(0, 1, Double.NEGATIVE_INFINITY);
        Assert.assertFalse((boolean)Matrices.isNonNegative(m));
    }

    @Test
    public void testSymmetric() {
        DenseMatrix m = new DenseMatrix(new double[2][1]);
        Assert.assertFalse((boolean)Matrices.isSymmetric(m));
        m = new DenseMatrix(new double[2][3]);
        Assert.assertFalse((boolean)Matrices.isSymmetric(m));
        m = new DenseMatrix(new double[3][3]);
        Assert.assertTrue((boolean)Matrices.isSymmetric(m));
        m.setValue(0, 0, 3.0);
        Assert.assertTrue((boolean)Matrices.isSymmetric(m));
        m.setValue(0, 1, 3.0);
        Assert.assertFalse((boolean)Matrices.isSymmetric(m));
        m.setValue(1, 0, 3.0);
        Assert.assertTrue((boolean)Matrices.isSymmetric(m));
        DenseMatrix m2 = new DenseMatrix(new double[][]{{0.0, 2.0, 1.0}, {2.0, 0.0, 1.0}, {1.0, 1.0, 3.0}});
        Assert.assertTrue((boolean)Matrices.isSymmetric(m2));
    }
}

