/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.sentences;

import com.aliasi.sentences.MedlineSentenceModel;
import com.aliasi.sentences.SentenceModel;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class MedlineSentenceModelTest {
    @Test
    public void testSerializable() throws IOException, ClassNotFoundException {
        junit.framework.Assert.assertNotNull((Object)AbstractExternalizable.serializeDeserialize(MedlineSentenceModel.INSTANCE));
    }

    @Test
    public void testBoundaries() {
        this.assertBoundaries(new String[0], new String[]{""}, new int[0]);
        this.assertBoundaries(new String[]{"."}, new String[]{"", ""}, new int[1]);
        this.assertBoundaries(new String[]{"p53", "."}, new String[]{" ", " ", ""}, new int[]{1});
        this.assertBoundaries(new String[]{"p53", "proteins", "."}, new String[]{" ", " ", " ", ""}, new int[]{2});
        this.assertBoundaries(new String[]{"p", "-", "53", "proteins", ".", "A", "b"}, new String[]{"", "", "", " ", "", " ", " ", " "}, new int[]{4, 6});
        this.assertBoundaries(new String[]{"Alpha", "bravo", ".", "abc", "def", "C"}, new String[]{"", " ", "", " ", "", " ", " "}, new int[]{5});
        this.assertBoundaries(new String[]{"(", "J", ".", "Child", "Dev", "P", ".", "53", ")", "."}, new String[]{"", "", " ", " ", " ", "", " ", "", "", "", ""}, new int[]{9});
        this.assertBoundaries(new String[]{"Apple", ")", "bravo", ".", "Charlie", "Tango"}, new String[]{"", " ", " ", " ", " ", " ", ""}, new int[]{3, 5});
        this.assertBoundaries(new String[]{"Apple", "(", "Bravo", ".", "Charlie", ")", "Dog", "."}, new String[]{"", " ", " ", " ", " ", " ", " ", " ", " "}, new int[]{7});
        this.assertBoundaries(new String[]{"Apple", "Bravo", ".", "Charlie"}, new String[]{"", " ", "", "", ""}, new int[]{3});
        this.assertBoundaries(new String[]{"Apple", "(", "Bravo", ".", "Charlie"}, new String[]{"", " ", " ", "", " ", ""}, new int[]{4});
        this.assertBoundaries(new String[]{"Apple", "(", ")", "Bravo", ".", "Charlie", "Tango"}, new String[]{"", " ", " ", " ", "", " ", " ", ""}, new int[]{4, 6});
    }

    private void assertBoundaries(String[] tokens, String[] whitespaces, int[] boundaries) {
        MedlineSentenceModel model = new MedlineSentenceModel();
        this.assertBoundaries(model, tokens, whitespaces, 0, tokens.length, boundaries);
    }

    private void assertBoundaries(SentenceModel model, String[] tokens, String[] whitespaces, int start, int length, int[] boundaries) {
        HashSet<Integer> boundariesSet = new HashSet<Integer>();
        model.boundaryIndices(tokens, whitespaces, start, length, boundariesSet);
        junit.framework.Assert.assertEquals((int)boundaries.length, (int)boundariesSet.size());
        int i = 0;
        while (i < boundaries.length) {
            junit.framework.Assert.assertTrue((boolean)boundariesSet.contains(boundaries[i]));
            ++i;
        }
        if (start == 0 && length == tokens.length) {
            int[] boundariesDerived = model.boundaryIndices(tokens, whitespaces);
            Assert.assertArrayEquals((int[])boundaries, (int[])boundariesDerived);
        }
    }
}

