/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.spell.AutoCompleter;
import com.aliasi.spell.FixedWeightEditDistance;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Math;
import com.aliasi.util.ScoredObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import junit.framework.Assert;
import org.junit.Test;

public class AutoCompleterTest {
    static final WeightedEditDistance EDIT_DISTANCE = new FixedWeightEditDistance(0.0, -10.0, -10.0, -10.0, Double.NEGATIVE_INFINITY);
    static final int MAX_QUEUE_SIZE = 1000;
    static final double MIN_SCORE = -40.0;

    @Test
    public void testOne() {
        Random random = new Random();
        long seed = random.nextLong();
        random = new Random(seed);
        String[] phrases = new String[]{"a", "abe", "able", "ace", "aces", "acing", "ad", "add", "be", "ben", "c"};
        HashMap<String, Double> phraseCounts = new HashMap<String, Double>();
        String[] stringArray = phrases;
        int n = phrases.length;
        int n2 = 0;
        while (n2 < n) {
            String phrase = stringArray[n2];
            phraseCounts.put(phrase, random.nextDouble());
            ++n2;
        }
        int maxResultsPerPrefix = 3;
        AutoCompleter completer = new AutoCompleter(phraseCounts, EDIT_DISTANCE, maxResultsPerPrefix, 1000, -40.0);
        Assert.assertNotNull((Object)completer);
    }

    @Test
    public void testBruteForce() {
        Random random = new Random();
        long seed = -3652569214004964184L;
        random = new Random(seed);
        int numPhrases = 5 + random.nextInt(500);
        HashMap<String, Float> phraseCounter = new HashMap<String, Float>();
        int i = 0;
        while (i < numPhrases) {
            String phrase;
            float randomScore = random.nextFloat();
            while (phraseCounter.containsKey(phrase = AutoCompleterTest.randomPhrase(random, 12))) {
            }
            phraseCounter.put(phrase, Float.valueOf(randomScore));
            ++i;
        }
        String[] queries = new String[100];
        int i2 = 0;
        while (i2 < queries.length) {
            queries[i2] = AutoCompleterTest.randomPhrase(random, 16);
            ++i2;
        }
        this.assertBruteForce(phraseCounter, EDIT_DISTANCE, 4, 5000000, queries);
    }

    static String randomPhrase(Random random, int size) {
        char[] cs = new char[1 + random.nextInt(size)];
        int i = 0;
        while (i < cs.length) {
            cs[i] = (char)(65 + random.nextInt(25));
            ++i;
        }
        return new String(cs);
    }

    void assertBruteForce(Map<String, ? extends Number> phraseCounter, WeightedEditDistance editDistance, int maxResults, int maxQueue, String[] queries) {
        String[] phrases = new String[phraseCounter.size()];
        float[] counts = new float[phraseCounter.size()];
        int k = 0;
        for (Map.Entry<String, ? extends Number> entry : phraseCounter.entrySet()) {
            phrases[k] = entry.getKey();
            counts[k] = entry.getValue().floatValue();
            ++k;
        }
        double totalCount = 0.0;
        int i = 0;
        while (i < counts.length) {
            totalCount += (double)counts[i];
            ++i;
        }
        double[] logProbs = new double[counts.length];
        int i2 = 0;
        while (i2 < counts.length) {
            logProbs[i2] = Math.log2((double)counts[i2] / totalCount);
            ++i2;
        }
        AutoCompleter completer = new AutoCompleter(phraseCounter, editDistance, maxResults, maxQueue, -40.0);
        String[] stringArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            String query = stringArray[n2];
            SortedSet<ScoredObject<String>> expectedResults = AutoCompleterTest.bruteForce(query, phrases, logProbs, editDistance, maxResults);
            SortedSet<ScoredObject<String>> results = completer.complete(query);
            Assert.assertEquals((int)expectedResults.size(), (int)results.size());
            Iterator expectedIt = expectedResults.iterator();
            Iterator resultsIt = results.iterator();
            int i3 = 0;
            while (i3 < expectedResults.size()) {
                ScoredObject expectedSo = (ScoredObject)expectedIt.next();
                ScoredObject resultSo = (ScoredObject)resultsIt.next();
                Assert.assertEquals((String)((String)expectedSo.getObject()), (String)((String)resultSo.getObject()));
                ++i3;
            }
            ++n2;
        }
    }

    static SortedSet<ScoredObject<String>> bruteForce(String query, String[] phrases, double[] logProbs, WeightedEditDistance editDistance, int maxResults) {
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        int k = 0;
        while (k < phrases.length) {
            int i = 0;
            while (i <= phrases[k].length()) {
                String prefix = phrases[k].substring(0, i);
                double proximity = editDistance.proximity(query, prefix);
                double score = logProbs[k] + proximity;
                if (score >= -40.0 && (!resultMap.containsKey(phrases[k]) || (Double)resultMap.get(phrases[k]) < score)) {
                    resultMap.put(phrases[k], score);
                }
                ++i;
            }
            ++k;
        }
        BoundedPriorityQueue<ScoredObject<String>> results = new BoundedPriorityQueue<ScoredObject<String>>(ScoredObject.comparator(), maxResults);
        for (Map.Entry entry : resultMap.entrySet()) {
            results.offer(new ScoredObject<String>((String)entry.getKey(), (Double)entry.getValue()));
        }
        return results;
    }
}

