/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.spell.TfIdfDistance;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;

public class TfIdfDistanceTest {
    @Test
    public void testOne() {
        IndoEuropeanTokenizerFactory tokenizerFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        TfIdfDistance distance = new TfIdfDistance(tokenizerFactory);
        distance.handle("abc de jj");
        distance.handle("de jj");
        distance.handle("abc de jj");
        distance.handle("fg jj");
        HashSet<String> expectedTerms = new HashSet<String>();
        expectedTerms.add("abc");
        expectedTerms.add("de");
        expectedTerms.add("fg");
        expectedTerms.add("jj");
        Assert.assertEquals(expectedTerms, distance.termSet());
        Assert.assertEquals((int)4, (int)distance.numDocuments());
        Assert.assertEquals((int)expectedTerms.size(), (int)distance.numTerms());
        Assert.assertEquals((int)0, (int)distance.docFrequency("k"));
        Assert.assertEquals((int)0, (int)distance.docFrequency("z"));
        Assert.assertEquals((int)1, (int)distance.docFrequency("fg"));
        Assert.assertEquals((int)2, (int)distance.docFrequency("abc"));
        Assert.assertEquals((int)3, (int)distance.docFrequency("de"));
        Assert.assertEquals((int)4, (int)distance.docFrequency("jj"));
        Assert.assertEquals((Object)0.0, (Object)distance.idf("k"));
        this.assertIdf(distance, "fg");
        this.assertIdf(distance, "abc");
        this.assertIdf(distance, "de");
        this.assertIdf(distance, "jj");
        this.assertDistance(1.0, "", "abc", distance);
        this.assertDistance(1.0, "abc", "de", distance);
        this.assertDistance(1.0, "abc jj", "de jj", distance);
        this.assertDistance(0.0, "k", "z", distance);
        this.assertDistance(0.0, "", "", distance);
        this.assertDistance(0.0, "abc", "abc", distance);
        this.assertDistance(0.0, "jj", "jj", distance);
        this.assertDistance(0.0, "abc jj", "abc jj", distance);
        this.assertDistance(0.0, "abc de jj", "de abc", distance);
        this.assertDistance(0.0, "abc de abc jj", "de abc abc", distance);
        this.assertDistance(0.0, "de abc de abc jj", "de abc abc de", distance);
        double idf_fg = distance.idf("fg");
        double idf_abc = distance.idf("abc");
        double idf_de = distance.idf("de");
        double expected = 1.0 - idf_fg / Math.sqrt((idf_fg + idf_de) * (idf_fg + idf_abc));
        this.assertDistance(expected, "fg abc", "fg de", distance);
    }

    void assertDistance(double expectedVal, String cs1, String cs2, TfIdfDistance distance) {
        Assert.assertEquals((double)expectedVal, (double)distance.distance(cs1, cs2), (double)0.001);
        Assert.assertEquals((double)expectedVal, (double)distance.distance(cs2, cs1), (double)0.001);
    }

    void assertIdf(TfIdfDistance distance, String cs) {
        Assert.assertEquals((double)Math.log((double)distance.numDocuments() / (double)distance.docFrequency(cs)), (double)distance.idf(cs), (double)0.001);
    }
}

