/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.lm.NGramProcessLM;
import com.aliasi.spell.FixedWeightEditDistance;
import com.aliasi.spell.TrainSpellChecker;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.test.unit.Asserts;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class TrainSpellCheckerTest {
    @Test
    public void testNullTF() throws IOException, ClassNotFoundException {
        NGramProcessLM lm = new NGramProcessLM(5);
        FixedWeightEditDistance distance = new FixedWeightEditDistance(1.0, 1.0, 1.0, 1.0, 1.0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, distance, null);
        lm.handle("A dog ran down the street.");
        Object o = AbstractExternalizable.compile(trainer);
        Assert.assertNotNull((Object)o);
    }

    @Test
    public void testEx() {
        NGramProcessLM lm = new NGramProcessLM(5);
        FixedWeightEditDistance distance = new FixedWeightEditDistance(1.0, 1.0, 1.0, 1.0, 1.0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, distance, IndoEuropeanTokenizerFactory.INSTANCE);
        try {
            trainer.train("tra la la", -1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    @Test
    public void testSerialize() throws Exception {
        NGramProcessLM lm = new NGramProcessLM(5);
        FixedWeightEditDistance distance = new FixedWeightEditDistance(1.0, 1.0, 1.0, 1.0, 1.0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, distance, IndoEuropeanTokenizerFactory.INSTANCE);
        trainer.handle("tra la la");
        trainer.handle("fa do");
        trainer.handle("do do");
        TrainSpellChecker trainer2 = (TrainSpellChecker)AbstractExternalizable.serializeDeserialize(trainer);
        Assert.assertEquals((long)trainer.numTrainingChars(), (long)trainer2.numTrainingChars());
        Assert.assertEquals(trainer.tokenCounter().keySet(), trainer2.tokenCounter().keySet());
        for (String key : trainer.tokenCounter().keySet()) {
            Assert.assertEquals((int)trainer.tokenCounter().getCount(key), (int)trainer2.tokenCounter().getCount(key));
        }
        WeightedEditDistance distance2 = trainer2.editDistance();
        Assert.assertEquals((Object)((WeightedEditDistance)distance).deleteWeight('a'), (Object)distance2.deleteWeight('a'));
        Assert.assertEquals((Object)((WeightedEditDistance)distance).transposeWeight('e', '1'), (Object)distance2.transposeWeight('e', '1'));
        Assert.assertEquals((Object)((WeightedEditDistance)distance).substituteWeight('F', '&'), (Object)distance2.substituteWeight('F', '&'));
        Assert.assertEquals((Object)((WeightedEditDistance)distance).matchWeight('-'), (Object)distance2.matchWeight('-'));
        NGramProcessLM lm2 = trainer2.languageModel();
        Assert.assertEquals((double)lm.log2Estimate("foo bar"), (double)lm2.log2Estimate("foo bar"), (double)1.0E-4);
    }
}

