/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.suffixarray;

import com.aliasi.suffixarray.CharSuffixArray;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CharSuffixArrayTest {
    @Test
    public void testAbracadabra() {
        String cs = "abracadabra";
        CharSuffixArray csa = new CharSuffixArray(cs);
        junit.framework.Assert.assertEquals((String)cs, (String)csa.text());
        int[] nArray = new int[11];
        nArray[0] = 10;
        nArray[1] = 7;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 4;
        nArray[8] = 6;
        nArray[9] = 9;
        nArray[10] = 2;
        int[] expected_sa = nArray;
        junit.framework.Assert.assertEquals((int)expected_sa.length, (int)csa.suffixArrayLength());
        int i = 0;
        while (i < expected_sa.length) {
            junit.framework.Assert.assertEquals((int)expected_sa[i], (int)csa.suffixArray(i));
            ++i;
        }
        List<int[]> prefixMatches = csa.prefixMatches(3);
        Assert.assertArrayEquals((int[])new int[]{1, 3}, (int[])prefixMatches.get(0));
        Assert.assertArrayEquals((int[])new int[]{5, 7}, (int[])prefixMatches.get(1));
        junit.framework.Assert.assertEquals((int)2, (int)prefixMatches.size());
    }

    @Test
    public void testEmpty() {
        String cs = "";
        CharSuffixArray csa = new CharSuffixArray(cs);
        junit.framework.Assert.assertEquals((String)cs, (String)csa.text());
        junit.framework.Assert.assertEquals((int)0, (int)csa.suffixArrayLength());
        junit.framework.Assert.assertEquals((int)0, (int)csa.prefixMatches(3).size());
    }

    @Test
    public void testBound() {
        String cs = "abababccc";
        CharSuffixArray csa = new CharSuffixArray(cs, 1);
        List<int[]> prefixMatches = csa.prefixMatches(1);
        junit.framework.Assert.assertEquals((int)3, (int)prefixMatches.size());
        for (int[] match : prefixMatches) {
            junit.framework.Assert.assertEquals((int)3, (int)(match[1] - match[0]));
            int j = match[0] + 1;
            while (j < match[1]) {
                junit.framework.Assert.assertEquals((char)cs.charAt(csa.suffixArray(j - 1)), (char)cs.charAt(csa.suffixArray(j)));
                ++j;
            }
        }
    }
}

