/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.suffixarray;

import com.aliasi.suffixarray.DocumentTokenSuffixArray;
import com.aliasi.suffixarray.TokenSuffixArray;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.Tokenization;
import com.aliasi.util.CollectionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class DocumentTokenSuffixArrayTest {
    @Test
    public void testDocs() {
        IndoEuropeanTokenizerFactory tf = IndoEuropeanTokenizerFactory.INSTANCE;
        String boundaryToken = "-----";
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("Doc2", "Mary ran home too");
        textMap.put("Doc1", "John ran home");
        textMap.put("Doc4", "The kid ran to the park");
        textMap.put("Doc3", "John ran to the store");
        DocumentTokenSuffixArray dtsa = new DocumentTokenSuffixArray(textMap, tf, Integer.MAX_VALUE, boundaryToken);
        TokenSuffixArray tsa = dtsa.suffixArray();
        Tokenization tokenization = tsa.tokenization();
        boolean pos = false;
        List<int[]> matches = tsa.prefixMatches(3);
        Assert.assertEquals((int)1, (int)matches.size());
        int[] match_span = matches.get(0);
        Assert.assertEquals((int)2, (int)(match_span[1] - match_span[0]));
        int idx1 = match_span[0];
        int idx2 = idx1 + 1;
        String match_string1 = tsa.substring(idx1, 3);
        String match_string2 = tsa.substring(idx1 + 1, 3);
        Assert.assertEquals((String)match_string1, (String)match_string2);
        Assert.assertEquals((String)"ran to the", (String)match_string1);
        Assert.assertEquals((int)0, (int)dtsa.docStartToken("Doc1"));
        Assert.assertEquals((int)3, (int)dtsa.docEndToken("Doc1"));
        Assert.assertEquals((int)4, (int)dtsa.docStartToken("Doc2"));
        Assert.assertEquals((int)8, (int)dtsa.docEndToken("Doc2"));
        Assert.assertEquals((int)9, (int)dtsa.docStartToken("Doc3"));
        Assert.assertEquals((int)14, (int)dtsa.docEndToken("Doc3"));
        Assert.assertEquals((int)15, (int)dtsa.docStartToken("Doc4"));
        Assert.assertEquals((int)21, (int)dtsa.docEndToken("Doc4"));
        int i = 0;
        while (i < 3) {
            Assert.assertEquals((String)"Doc1", (String)dtsa.textPositionToDocId(i));
            ++i;
        }
        i = 4;
        while (i < 8) {
            Assert.assertEquals((String)"Doc2", (String)dtsa.textPositionToDocId(i));
            ++i;
        }
        i = 9;
        while (i < 14) {
            Assert.assertEquals((String)"Doc3", (String)dtsa.textPositionToDocId(i));
            ++i;
        }
        i = 15;
        while (i < 21) {
            Assert.assertEquals((String)"Doc4", (String)dtsa.textPositionToDocId(i));
            ++i;
        }
        int pos1 = tsa.suffixArray(idx1);
        int pos2 = tsa.suffixArray(idx1 + 1);
        int first_pos = Math.min(pos1, pos2);
        int second_pos = Math.max(pos1, pos2);
        String doc_id1 = dtsa.textPositionToDocId(pos1);
        String doc_id2 = dtsa.textPositionToDocId(pos2);
        Assert.assertEquals(CollectionUtils.asSet("Doc1", "Doc2", "Doc3", "Doc4"), dtsa.documentNames());
        HashSet<String> expected_doc_set = CollectionUtils.asSet("Doc3", "Doc4");
        HashSet<String> doc_set = CollectionUtils.asSet(doc_id1, doc_id2);
        Assert.assertEquals(expected_doc_set, doc_set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadBoundary() {
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("doc", "Hello world");
        String boundaryToken = "DOC BOUNDARY";
        IndoEuropeanTokenizerFactory tf = IndoEuropeanTokenizerFactory.INSTANCE;
        DocumentTokenSuffixArray dtsa = new DocumentTokenSuffixArray(textMap, tf, Integer.MAX_VALUE, boundaryToken);
    }

    @Test
    public void testSimple() {
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("doc1", "John ran home.");
        textMap.put("doc2", "Mary also ran home.");
        String boundaryToken = "DOCBOUNDARY";
        IndoEuropeanTokenizerFactory tf = IndoEuropeanTokenizerFactory.INSTANCE;
        DocumentTokenSuffixArray dtsa = new DocumentTokenSuffixArray(textMap, tf, Integer.MAX_VALUE, boundaryToken);
        Assert.assertNotNull((Object)dtsa);
    }

    @Test
    public void testPriceIsRightEmpty() {
        int[] vs = new int[]{};
        Assert.assertEquals((int)-1, (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, 3));
    }

    @Test
    public void testPriceIsRight2() {
        int[] nArray = new int[6];
        nArray[1] = 17;
        nArray[2] = 23;
        nArray[3] = 152;
        nArray[4] = 153;
        nArray[5] = 190;
        int[] vs = nArray;
        Assert.assertEquals((int)-1, (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, -10));
        int k = 0;
        while (k + 1 < vs.length) {
            int i = vs[k];
            while (i < vs[k + 1]) {
                Assert.assertEquals((int)k, (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, i));
                ++i;
            }
            ++k;
        }
        Assert.assertEquals((int)(vs.length - 1), (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, 190));
        Assert.assertEquals((int)(vs.length - 1), (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, 195));
        Assert.assertEquals((int)(vs.length - 1), (int)DocumentTokenSuffixArray.largestWithoutGoingOver(vs, Integer.MAX_VALUE));
    }
}

