/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToCounterMap;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class TokenFeatureExtractorTest {
    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        TokenFeatureExtractor extractor1 = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
        TokenFeatureExtractor extractor2 = (TokenFeatureExtractor)AbstractExternalizable.serializeDeserialize(extractor1);
        String in0 = "";
        ObjectToCounterMap<String> expectedMap0 = new ObjectToCounterMap<String>();
        this.assertEx(extractor1, in0, expectedMap0);
        this.assertEx(extractor2, in0, expectedMap0);
        String in1 = "a a b";
        ObjectToCounterMap<String> expectedMap1 = new ObjectToCounterMap<String>();
        expectedMap1.set("a", 2);
        expectedMap1.set("b", 1);
        this.assertEx(extractor1, in1, expectedMap1);
        this.assertEx(extractor2, in1, expectedMap1);
    }

    void assertEx(FeatureExtractor<CharSequence> extractor, String input, Map<String, ? extends Number> expectedMap) {
        Map<String, Number> map = extractor.features(input);
        Assert.assertEquals((int)expectedMap.size(), (int)map.size());
        for (String key : expectedMap.keySet()) {
            Assert.assertEquals((double)expectedMap.get(key).doubleValue(), (double)map.get(key).doubleValue(), (double)1.0E-4);
        }
    }
}

