/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenLengthTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import org.junit.Test;

public class TokenLengthTokenizerFactoryTest {
    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        TokenLengthTokenizerFactory factory = new TokenLengthTokenizerFactory(ieFactory, 2, 3);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "A bb cccc", "bb");
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a aaaa b bbbbbbbb 7474747", new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void textConstructException1() {
        new TokenLengthTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY, 3, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void textConstructException2() {
        new TokenLengthTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY, -1, 2);
    }

    @Test
    public void testNotSerializable() {
        TokenLengthTokenizerFactory unserializable = new TokenLengthTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY, 2, 4);
        Asserts.assertNotSerializable(unserializable);
    }
}

