/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.tokenizer.CharacterTokenizerFactory;
import com.aliasi.tokenizer.EnglishStopTokenizerFactory;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.LowerCaseTokenizerFactory;
import com.aliasi.tokenizer.NGramTokenizerFactory;
import com.aliasi.tokenizer.RegExTokenizerFactory;
import com.aliasi.tokenizer.Tokenization;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.tokenizer.WhitespaceNormTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class TokenizationTest {
    @Test
    public void testConstructorBase() {
        int[] nArray = new int[2];
        nArray[1] = 5;
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", "", ""), nArray, new int[]{4, 8}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorEx1() {
        int[] nArray = new int[2];
        nArray[1] = 5;
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", ""), nArray, new int[]{4, 8}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorEx2() {
        int[] nArray = new int[2];
        nArray[1] = -5;
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", "", ""), nArray, new int[]{4, 8}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorEx3() {
        int[] nArray = new int[2];
        nArray[1] = 5;
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", "", ""), nArray, new int[]{4, 9}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorEx4() {
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 6;
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", "", ""), nArray, new int[]{4, 8}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorEx5() {
        junit.framework.Assert.assertNotNull((Object)new Tokenization("John ran", Arrays.asList("John", "ran"), Arrays.asList("", "", ""), new int[1], new int[]{4, 8}));
    }

    @Test
    public void testDirect() {
        Tokenization tok1 = new Tokenization("John ran.\n", IndoEuropeanTokenizerFactory.INSTANCE);
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 8;
        Tokenization tok2 = new Tokenization("John ran.\n", Arrays.asList("John", "ran", "."), Arrays.asList("", " ", "", "\n"), nArray, new int[]{4, 8, 9});
        Asserts.assertFullEquals(tok1, tok2);
    }

    @Test
    public void testGetters() {
        Tokenization tok = new Tokenization("John ran.\n", IndoEuropeanTokenizerFactory.INSTANCE);
        junit.framework.Assert.assertEquals((String)"John ran.\n", (String)tok.text());
        junit.framework.Assert.assertEquals((int)3, (int)tok.numTokens());
        junit.framework.Assert.assertEquals((String)"John", (String)tok.token(0));
        junit.framework.Assert.assertEquals((String)"ran", (String)tok.token(1));
        junit.framework.Assert.assertEquals((String)".", (String)tok.token(2));
        junit.framework.Assert.assertEquals((String)"", (String)tok.whitespace(0));
        junit.framework.Assert.assertEquals((String)" ", (String)tok.whitespace(1));
        junit.framework.Assert.assertEquals((String)"", (String)tok.whitespace(2));
        junit.framework.Assert.assertEquals((String)"\n", (String)tok.whitespace(3));
        junit.framework.Assert.assertEquals((int)0, (int)tok.tokenStart(0));
        junit.framework.Assert.assertEquals((int)5, (int)tok.tokenStart(1));
        junit.framework.Assert.assertEquals((int)8, (int)tok.tokenStart(2));
        junit.framework.Assert.assertEquals((int)4, (int)tok.tokenEnd(0));
        junit.framework.Assert.assertEquals((int)8, (int)tok.tokenEnd(1));
        junit.framework.Assert.assertEquals((int)9, (int)tok.tokenEnd(2));
        junit.framework.Assert.assertEquals(Arrays.asList("John", "ran", "."), tok.tokenList());
        junit.framework.Assert.assertEquals(Arrays.asList("", " ", "", "\n"), tok.whitespaceList());
        Assert.assertArrayEquals((Object[])new String[]{"John", "ran", "."}, (Object[])tok.tokens());
        Assert.assertArrayEquals((Object[])new String[]{"", " ", "", "\n"}, (Object[])tok.whitespaces());
    }

    @Test
    public void testDifferent() throws IOException {
        Tokenization tok1 = new Tokenization("John ran.", IndoEuropeanTokenizerFactory.INSTANCE);
        Tokenization tok2 = new Tokenization("Mary ran.", IndoEuropeanTokenizerFactory.INSTANCE);
        junit.framework.Assert.assertFalse((boolean)tok1.equals(tok2));
        junit.framework.Assert.assertFalse((boolean)tok2.equals(tok1));
        Tokenization tok1s = (Tokenization)AbstractExternalizable.serializeDeserialize(tok1);
        Tokenization tok2s = (Tokenization)AbstractExternalizable.serializeDeserialize(tok2);
        junit.framework.Assert.assertFalse((boolean)tok1.equals(tok2s));
        junit.framework.Assert.assertFalse((boolean)tok2.equals(tok1s));
        junit.framework.Assert.assertFalse((boolean)tok1s.equals(tok2));
        junit.framework.Assert.assertFalse((boolean)tok2s.equals(tok1));
    }

    @Test
    public void testToks() {
        this.assertTokenizations("");
        this.assertTokenizations("John");
        this.assertTokenizations("John ran.");
        this.assertTokenizations("he does not run and i do   be\nwalk.");
    }

    void assertTokenizations(String text) {
        this.assertTokenizations(text, IndoEuropeanTokenizerFactory.INSTANCE, CharacterTokenizerFactory.INSTANCE, new RegExTokenizerFactory("\\s+"), new NGramTokenizerFactory(2, 3), new LowerCaseTokenizerFactory(IndoEuropeanTokenizerFactory.INSTANCE), new EnglishStopTokenizerFactory(new LowerCaseTokenizerFactory(IndoEuropeanTokenizerFactory.INSTANCE)), new WhitespaceNormTokenizerFactory(IndoEuropeanTokenizerFactory.INSTANCE));
    }

    void assertTokenizations(String text, TokenizerFactory ... factories) {
        TokenizerFactory[] tokenizerFactoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            TokenizerFactory factory = tokenizerFactoryArray[n2];
            char[] cs = ("AB" + text + "C").toCharArray();
            int start = 2;
            int length = text.length();
            Tokenization tok1 = new Tokenization(cs, start, length, factory);
            Tokenization tok2 = new Tokenization(text, factory);
            Asserts.assertFullEquals(tok1, tok2);
            ++n2;
        }
    }
}

