/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class TokenizerTest {
    static final TokenizerFactory UNSERIALIZABLE_FACTORY = new TokenizerFactory(){

        @Override
        public Tokenizer tokenizer(char[] cs, int start, int len) {
            return null;
        }

        public Tokenizer transform(String s) {
            return this.tokenizer(s.toCharArray(), 0, s.length());
        }
    };

    @Test
    public void testAbstractTokenizerStart() throws IOException {
        TestTokenizer testTokenizer = new TestTokenizer();
        boolean threw = false;
        try {
            testTokenizer.lastTokenStartPosition();
        }
        catch (UnsupportedOperationException e) {
            threw = true;
        }
        junit.framework.Assert.assertTrue((boolean)threw);
    }

    @Test
    public void testAbstractTokenizerWhitespace() throws IOException {
        TestTokenizer testTokenizer = new TestTokenizer();
        int i = 0;
        while (i < 20) {
            junit.framework.Assert.assertEquals((String)" ", (String)testTokenizer.nextWhitespace());
            ++i;
        }
        i = 0;
        while (i < 20) {
            ((Tokenizer)testTokenizer).nextToken();
            ++i;
        }
        junit.framework.Assert.assertEquals((String)" ", (String)testTokenizer.nextWhitespace());
    }

    @Test
    public void testAbstractTokenizerNext() throws IOException {
        TestTokenizer testTokenizer = new TestTokenizer();
        int i = 1;
        while (i <= 10) {
            junit.framework.Assert.assertEquals((String)String.valueOf(i), (String)((Tokenizer)testTokenizer).nextToken());
            ++i;
        }
        junit.framework.Assert.assertNull((Object)((Tokenizer)testTokenizer).nextToken());
    }

    @Test
    public void testAbstractTokenizerToArray() throws IOException {
        TestTokenizer testTokenizer = new TestTokenizer();
        Object[] answer = new String[10];
        int i = 0;
        while (i < 10) {
            answer[i] = String.valueOf(i + 1);
            ++i;
        }
        Assert.assertArrayEquals((Object[])answer, (Object[])testTokenizer.tokenize());
    }

    @Test
    public void testIterability() {
        TestTokenizer tokenizer = new TestTokenizer();
        int count = 0;
        for (String token : tokenizer) {
            junit.framework.Assert.assertEquals((String)String.valueOf(++count), (String)token);
        }
        junit.framework.Assert.assertEquals((int)10, (int)count);
    }

    public static void assertFactory(TokenizerFactory factory, String input, String ... tokens) {
        TokenizerTest.assertFactory(factory, input, tokens, null);
    }

    public static void assertFactory(TokenizerFactory factory, String input, String[] tokens, String[] whitespaces) {
        TokenizerTest.assertTokenization(factory, input, tokens, whitespaces);
        if (!(factory instanceof Serializable)) {
            return;
        }
        try {
            TokenizerFactory deserializedFactory = (TokenizerFactory)AbstractExternalizable.serializeDeserialize((Serializable)((Object)factory));
            TokenizerTest.assertTokenization(deserializedFactory, input, tokens, whitespaces);
        }
        catch (IOException e) {
            junit.framework.Assert.fail((String)e.toString());
        }
    }

    public static void assertTokenization(TokenizerFactory factory, String input, String[] tokens, String[] whitespaces) {
        Tokenizer tokenizer = factory.tokenizer(input.toCharArray(), 0, input.length());
        if (whitespaces != null) {
            junit.framework.Assert.assertEquals((String)whitespaces[0], (String)tokenizer.nextWhitespace());
        }
        int i = 0;
        while (i < tokens.length) {
            junit.framework.Assert.assertEquals((String)tokens[i], (String)tokenizer.nextToken());
            if (whitespaces != null) {
                junit.framework.Assert.assertEquals((String)whitespaces[i + 1], (String)tokenizer.nextWhitespace());
            }
            ++i;
        }
        junit.framework.Assert.assertNull((Object)tokenizer.nextToken());
    }

    private static class TestTokenizer
    extends Tokenizer {
        private int count = 0;

        private TestTokenizer() {
        }

        @Override
        public String nextToken() {
            return this.count++ < 10 ? String.valueOf(this.count) : null;
        }
    }
}

