/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FastCache;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public class FastCacheTest {
    @Test
    public void testSerialize() throws IOException {
        FastCache<String, String> fc = new FastCache<String, String>(100, 0.5);
        fc.put("a", "b");
        fc.put("c", "d");
        Assert.assertEquals((int)2, (int)fc.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        FastCache fc2 = (FastCache)AbstractExternalizable.serializeDeserialize(fc);
        Assert.assertEquals((int)2, (int)fc2.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        Assert.assertFalse((boolean)fc.containsKey("d"));
    }

    @Test
    public void testClear() {
        FastCache<String, String> fc = new FastCache<String, String>(100, 0.5);
        fc.put("a", "b");
        fc.put("c", "d");
        Assert.assertEquals((int)2, (int)fc.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        fc.clear();
        Assert.assertEquals((int)0, (int)fc.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException1() {
        new FastCache(0, 0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException2() {
        new FastCache(-10, 0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException3() {
        new FastCache(5, -0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException4() {
        new FastCache(5, Double.NaN);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException5() {
        new FastCache(5, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testOne() {
        int numIts = 100000;
        FastCache<Long, int[]> cache = new FastCache<Long, int[]>(5000000, 1.0);
        long i = 0L;
        while (i < (long)numIts) {
            cache.put(i, new int[(int)(i % 10L)]);
            ++i;
        }
        i = 0L;
        while (i < (long)numIts) {
            Assert.assertEquals((int)((int)(i % 10L)), (int)((int[])cache.get(i)).length);
            ++i;
        }
    }

    @Test
    public void testRecover() {
        int megabyte = 1000000;
        int numMegabytes = 100;
        FastCache<Integer, int[]> cache = new FastCache<Integer, int[]>(5000000, 1.0);
        int i = 0;
        while (i < numMegabytes) {
            cache.put(i, new int[megabyte]);
            ++i;
        }
        Asserts.succeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc1() {
        new FastCache(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc2() {
        new FastCache(1, 0.0);
    }

    @Test
    public void testPrune() {
        FastCache<Integer, Integer> cache = new FastCache<Integer, Integer>(150, 0.5);
        int max = 10000;
        int i = 0;
        while (i < max) {
            cache.put(i, i / 2);
            ++i;
        }
        Assert.assertTrue((cache.size() < 75 ? 1 : 0) != 0);
    }

    @Test
    public void testMulti() throws InterruptedException {
        int numThreads = 128;
        int numEntries = 32;
        ConcurrentHashMap<Integer, Integer> cache = new ConcurrentHashMap<Integer, Integer>();
        CacheTest[] cacheTests = new CacheTest[numThreads];
        int i = 0;
        while (i < numThreads) {
            cacheTests[i] = new CacheTest(cache, numEntries);
            ++i;
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads * 3 / 4);
        CacheTest[] cacheTestArray = cacheTests;
        int n = cacheTests.length;
        int n2 = 0;
        while (n2 < n) {
            CacheTest testCache = cacheTestArray[n2];
            executor.execute(testCache);
            ++n2;
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        int j = 0;
        while (j < numEntries) {
            Integer val = (Integer)cache.get(j);
            if (val != null) {
                Assert.assertEquals((Object)val, (Object)(j / 2));
            }
            ++j;
        }
        int sumHits = 0;
        int i2 = 0;
        while (i2 < numThreads) {
            sumHits += cacheTests[i2].mHits;
            ++i2;
        }
        int misses = numThreads * numEntries - sumHits;
    }

    static class CacheTest
    implements Runnable {
        final Map<Integer, Integer> mCache;
        final int mNumEntries;
        int mHits = 0;

        CacheTest(Map<Integer, Integer> cache, int numEntries) {
            this.mCache = cache;
            this.mNumEntries = numEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random random = new Random();
            int j = 0;
            while (j < this.mNumEntries) {
                try {
                    Thread.sleep(random.nextInt(1));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.mCache.get(j) != null) {
                    CacheTest cacheTest = this;
                    synchronized (cacheTest) {
                        ++this.mHits;
                    }
                } else {
                    this.mCache.put(j, j / 2);
                }
                ++j;
            }
        }
    }
}

