/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.HardFastCache;
import junit.framework.Assert;
import org.junit.Test;

public class HardFastCacheTest {
    @Test
    public void testOne() {
        int numIts = 100000;
        HardFastCache<Long, int[]> cache = new HardFastCache<Long, int[]>(5000000, 1.0);
        long i = 0L;
        while (i < (long)numIts) {
            cache.put(i, new int[(int)(i % 10L)]);
            ++i;
        }
        i = 0L;
        while (i < (long)numIts) {
            Assert.assertEquals((int)((int)(i % 10L)), (int)((int[])cache.get(i)).length);
            ++i;
        }
    }

    @Test
    public void testRecover() {
        int megabyte = 1000000;
        int numMegabytes = 100;
        HardFastCache<Integer, int[]> cache = new HardFastCache<Integer, int[]>(5000000, 1.0);
        int i = 0;
        while (i < numMegabytes) {
            cache.put(i, new int[megabyte]);
            ++i;
        }
        Asserts.succeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc1() {
        new HardFastCache(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc2() {
        new HardFastCache(1, 0.0);
    }

    @Test
    public void testPrune() {
        HardFastCache<Integer, Integer> cache = new HardFastCache<Integer, Integer>(150, 0.5);
        int max = 10000;
        int i = 0;
        while (i < max) {
            cache.put(i, i / 2);
            ++i;
        }
        Assert.assertTrue((cache.size() < 75 ? 1 : 0) != 0);
    }

    @Test
    public void testMulti() throws InterruptedException {
        HardFastCache cache = new HardFastCache(1000000, 1.0);
        int numThreads = 2;
        int numEntries = 8;
        Thread[] threads = new Thread[numThreads];
        int i = 0;
        while (i < numThreads) {
            threads[i] = new Thread(new TestCache(cache, numEntries));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < numThreads) {
            threads[i].join();
            ++i;
        }
        i = 0;
        while (i < numEntries) {
            Integer val = (Integer)cache.get(i);
            if (val != null) {
                Assert.assertEquals((Object)val, (Object)(i / 2));
            }
            ++i;
        }
    }

    private static class TestCache
    implements Runnable {
        final HardFastCache mCache;
        int mNum;

        TestCache(HardFastCache cache, int num) {
            this.mCache = cache;
            this.mNum = num;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.mNum) {
                this.mCache.put(i, i / 2);
                ++i;
            }
        }
    }
}

