/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class MathTest {
    static double[][] DIGAMMA_TESTS = new double[][]{{-10.0, Double.NaN}, {-9.8, -1.99149533102274}, {-9.6, 1.29217785271165}, {-9.4, 3.31372445948209}, {-9.2, 6.59659923473126}, {-9.0, Double.NaN}, {-8.8, -2.09353614734927}, {-8.6, 1.18801118604499}, {-8.4, 3.20734148075868}, {-8.2, 6.48790358255735}, {-8.0, Double.NaN}, {-7.8, -2.2071725109856}, {-7.6, 1.07173211627754}, {-7.4, 3.08829386171106}, {-7.2, 6.36595236304515}, {-7.0, Double.NaN}, {-6.8, -2.33537763919073}, {-6.6, 0.940153168909122}, {-6.4, 2.95315872657593}, {-6.2, 6.22706347415626}, {-6.0, Double.NaN}, {-5.8, -2.48243646272015}, {-5.6, 0.78863801739397}, {-5.4, 2.79690872657593}, {-5.2, 6.06577315157562}, {-5.0, Double.NaN}, {-4.8, -2.65485025582359}, {-4.6, 0.610066588822547}, {-4.4, 2.61172354139075}, {-4.2, 5.87346545926791}, {-4.0, Double.NaN}, {-3.8, -2.86318358915693}, {-3.6, 0.392675284474721}, {-3.4, 2.38445081411802}, {-3.2, 5.63537022117267}, {-3.0, Double.NaN}, {-2.8, -3.12634148389377}, {-2.6, 0.114897506696942}, {-2.4, 2.0903331670592}, {-2.2, 5.32287022117267}, {-2.0, Double.NaN}, {-1.8, -3.4834843410366}, {-1.6, -0.269717877918446}, {-1.4, 1.67366650039252}, {-1.2, 4.86832476662722}, {-1.0, Double.NaN}, {-0.8, -4.03903989659216}, {-0.6, -0.894717877918445}, {-0.4, 0.959380786106823}, {-0.2, 4.03499143329388}, {0.0, Double.NaN}, {0.2, -5.28903989659216}, {0.4, -2.56138454458511}, {0.6, -1.54061921389319}, {0.8, -0.965008566706137}, {1.0, -0.577215664901533}, {1.2, -0.289039896592187}, {1.4, -0.0613845445851157}, {1.6, 0.126047452773477}, {1.8, 0.284991433293862}, {2.0, 0.422784335098467}, {2.2, 0.544293436741145}, {2.4, 0.652901169700598}, {2.6, 0.751047452773477}, {2.8, 0.840546988849417}, {3.0, 0.922784335098467}, {3.2, 0.9988388912866}, {3.4, 1.06956783636727}, {3.6, 1.13566283738886}, {3.8, 1.19768984599227}, {4.0, 1.2561176684318}, {4.2, 1.3113388912866}, {4.4, 1.36368548342609}, {4.6, 1.41344061516664}, {4.8, 1.46084774072912}, {5.0, 1.5061176684318}, {5.2, 1.54943412938184}, {5.4, 1.59095821069882}, {5.6, 1.63083191951446}, {5.8, 1.66918107406245}, {6.0, 1.7061176684318}, {6.2, 1.74174182168953}, {6.4, 1.776143395884}, {6.6, 1.80940334808589}, {6.8, 1.8415948671659}, {7.0, 1.87278433509847}, {7.2, 1.90303214427017}, {7.4, 1.932393395884}, {7.6, 1.96091849960104}, {7.8, 1.98865369069531}, {8.0, 2.01564147795561}, {8.2, 2.04192103315906}, {8.4, 2.06752853101914}, {8.6, 2.09249744696947}, {8.8, 2.11685881890044}, {9.0, 2.14064147795561}, {9.2, 2.16387225267126}, {9.4, 2.18657615006676}, {9.6, 2.20877651673691}, {9.8, 2.2304951825368}, {10.0, 2.25175258906672}};
    static double[][] GAMMA_INPUT_NATLOGOUT_TESTS = new double[][]{{0.1, 2.25271}, {0.2, 1.52406}, {0.3, 1.0958}, {0.4, 0.796678}, {0.5, 0.57236494}, {0.6, 0.39823386}, {0.7, 0.26086725}, {0.8, 0.15205968}, {0.9, 0.06637624}, {1.0, 0.0}, {1.1, -0.04987244}, {1.2, -0.08537409}, {1.3, -0.10817481}, {1.4, -0.11961291}, {1.5, -0.12078224}};

    @Test
    public void testDigamma() {
        double[][] dArray = DIGAMMA_TESTS;
        int n = DIGAMMA_TESTS.length;
        int n2 = 0;
        while (n2 < n) {
            double[] xFx = dArray[n2];
            double x = xFx[0];
            double digamma_x = xFx[1];
            double val = Math.digamma(x);
            if (Double.isNaN(digamma_x)) {
                Assert.assertTrue((boolean)Double.isNaN(val));
            } else {
                Assert.assertEquals((double)digamma_x, (double)val, (double)1.0E-13);
            }
            ++n2;
        }
    }

    @Test
    public void testGamma() {
        int i = 2;
        while (i < 100) {
            Assert.assertEquals((double)Math.log2Factorial(i - 1), (double)Math.log2Gamma(i), (double)1.0E-4);
            ++i;
        }
        double[][] dArray = GAMMA_INPUT_NATLOGOUT_TESTS;
        int n = GAMMA_INPUT_NATLOGOUT_TESTS.length;
        int n2 = 0;
        while (n2 < n) {
            double[] pair = dArray[n2];
            double z = pair[0];
            double logEGammaZ = pair[1];
            double gammaZ = java.lang.Math.exp(logEGammaZ);
            double log2GammaZ = Math.log2(gammaZ);
            double foundLog2GammaZ = Math.log2Gamma(z);
            Assert.assertEquals((double)log2GammaZ, (double)Math.log2Gamma(z), (double)1.0E-4);
            ++n2;
        }
    }

    @Test
    public void testNextPrime() {
        Assert.assertEquals((int)2, (int)Math.nextPrime(-7));
        Assert.assertEquals((int)2, (int)Math.nextPrime(-2));
        Assert.assertEquals((int)2, (int)Math.nextPrime(-1));
        Assert.assertEquals((int)2, (int)Math.nextPrime(0));
        Assert.assertEquals((int)2, (int)Math.nextPrime(1));
        Assert.assertEquals((int)3, (int)Math.nextPrime(2));
        Assert.assertEquals((int)5, (int)Math.nextPrime(3));
        Assert.assertEquals((int)7, (int)Math.nextPrime(5));
        Assert.assertEquals((int)11, (int)Math.nextPrime(7));
        Assert.assertEquals((int)103, (int)Math.nextPrime(101));
    }

    @Test
    public void testIsPrime() {
        Assert.assertFalse((boolean)Math.isPrime(-7));
        Assert.assertFalse((boolean)Math.isPrime(-2));
        Assert.assertFalse((boolean)Math.isPrime(-1));
        Assert.assertFalse((boolean)Math.isPrime(0));
        Assert.assertFalse((boolean)Math.isPrime(1));
        Assert.assertTrue((boolean)Math.isPrime(2));
        Assert.assertTrue((boolean)Math.isPrime(3));
        Assert.assertFalse((boolean)Math.isPrime(4));
        Assert.assertTrue((boolean)Math.isPrime(5));
        Assert.assertFalse((boolean)Math.isPrime(6));
        Assert.assertFalse((boolean)Math.isPrime(25));
        Assert.assertFalse((boolean)Math.isPrime(100));
        Assert.assertTrue((boolean)Math.isPrime(101));
        Assert.assertFalse((boolean)Math.isPrime(999));
        Assert.assertFalse((boolean)Math.isPrime(1024));
    }

    @Test
    public void testLN_2() {
        Assert.assertEquals((double)Math.LN_2, (double)java.lang.Math.log(2.0), (double)5.0E-4);
    }

    @Test
    public void testNaturalToBase2() {
        Assert.assertEquals((double)1.0, (double)Math.naturalLogToBase2Log(java.lang.Math.log(2.0)), (double)5.0E-4);
        Assert.assertEquals((double)3.0, (double)Math.naturalLogToBase2Log(java.lang.Math.log(8.0)), (double)5.0E-4);
        Assert.assertEquals((double)-3.0, (double)Math.naturalLogToBase2Log(java.lang.Math.log(0.125)), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)Math.naturalLogToBase2Log(java.lang.Math.log(1.0)), (double)5.0E-4);
    }

    @Test
    public void testLogBase2ToNaturalLog() {
        Assert.assertEquals((double)java.lang.Math.log(8.0), (double)Math.logBase2ToNaturalLog(3.0), (double)1.0E-4);
        Assert.assertEquals((double)java.lang.Math.log(0.5), (double)Math.logBase2ToNaturalLog(-1.0), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Math.logBase2ToNaturalLog(0.0), (double)1.0E-4);
    }

    @Test
    public void testByteAsUnsigned() {
        Assert.assertEquals((int)0, (int)Math.byteAsUnsigned((byte)0));
        Assert.assertEquals((int)12, (int)Math.byteAsUnsigned((byte)12));
        Assert.assertEquals((int)128, (int)Math.byteAsUnsigned((byte)-128));
        Assert.assertEquals((int)200, (int)Math.byteAsUnsigned((byte)-56));
        Assert.assertEquals((int)255, (int)Math.byteAsUnsigned((byte)-1));
    }

    @Test
    public void testLnFactorial() {
        Assert.assertEquals((double)MathTest.log2FactorialFull(0), (double)Math.log2Factorial(0L), (double)5.0E-4);
        Assert.assertEquals((double)MathTest.log2FactorialFull(10), (double)Math.log2Factorial(10L), (double)5.0E-4);
        Assert.assertEquals((double)MathTest.log2FactorialFull(100), (double)Math.log2Factorial(100L), (double)5.0E-4);
        Assert.assertEquals((double)MathTest.log2FactorialFull(101), (double)Math.log2Factorial(101L), (double)5.0E-4);
        Assert.assertEquals((double)MathTest.log2FactorialFull(1000), (double)Math.log2Factorial(1000L), (double)5.0E-4);
        Assert.assertEquals((double)MathTest.log2FactorialFull(1001), (double)Math.log2Factorial(1001L), (double)5.0E-4);
    }

    private static double log2FactorialFull(int n) {
        if (n == 0) {
            return 0.0;
        }
        return Math.log2(n) + MathTest.log2FactorialFull(n - 1);
    }

    @Test
    public void testInfiniteMaximum() {
        double max = Math.maximum(Double.NEGATIVE_INFINITY, 1.0, 2.0);
        Assert.assertEquals((double)2.0, (double)max, (double)1.0E-4);
    }

    @Test
    public void testLogSumOfExponentials() {
        MathTest.assertLogSumOfExponentials(1.0);
        MathTest.assertLogSumOfExponentials(1.0, 2.0);
        MathTest.assertLogSumOfExponentials(-10.0, 20.0, 13.0, 0.0);
        MathTest.assertLogSumOfExponentials(Double.NEGATIVE_INFINITY, 1.0, 2.0);
        MathTest.assertLogSumOfExponentials(Double.NEGATIVE_INFINITY, 1.0);
        MathTest.assertLogSumOfExponentials(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)10000.0, (double)Math.logSumOfExponentials(new double[]{10000.0}), (double)1.0E-4);
    }

    @Test
    public void testMax() {
        Assert.assertTrue((boolean)Double.isNaN(Math.max(new double[0])));
        Assert.assertTrue((boolean)Double.isNaN(Math.max(Double.NaN)));
        Assert.assertTrue((boolean)Double.isNaN(Math.max(Double.NaN, 1.0)));
        Assert.assertTrue((boolean)Double.isNaN(Math.max(1.0, Double.NaN)));
        Assert.assertTrue((boolean)Double.isNaN(Math.max(1.0, 2.0, Double.NaN)));
        Assert.assertEquals((Object)1.0, (Object)Math.max(1.0));
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Math.max(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)2.0, (Object)Math.max(1.0, 2.0));
        Assert.assertEquals((Object)2.0, (Object)Math.max(2.0, 1.0));
        Assert.assertEquals((Object)2.0, (Object)Math.max(2.0, 1.0, -1.0));
    }

    static void assertLogSumOfExponentials(double ... xs) {
        double sum = 0.0;
        int i = 0;
        while (i < xs.length) {
            sum += java.lang.Math.exp(xs[i]);
            ++i;
        }
        double expected = java.lang.Math.log(sum);
        Assert.assertEquals((double)expected, (double)Math.logSumOfExponentials(xs), (double)1.0E-4);
    }
}

