/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.Strings;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import org.junit.Assert;
import org.junit.Test;

public class StringsTest {
    @Test
    public void testIsLegalUnicode() {
        this.assertLegal("");
        this.assertLegal("abc");
        this.assertLegal("\uffff");
        this.assertLegal("\ufffe");
        this.assertLegal("\ud800\udc00");
        this.assertLegal("\ud800\udc00a");
        this.assertLegal("a\ud800\udc00");
        this.assertLegal("a\ud800\udc00bbb");
        this.assertIllegal("\udc00\ud800");
        this.assertIllegal("a\udc00\ud800");
        this.assertIllegal("\udc00\ud800b");
        this.assertIllegal("aa\udc00\ud800bb");
    }

    void assertLegal(String s) {
        junit.framework.Assert.assertTrue((String)s, (boolean)Strings.isLegalUtf16(s));
    }

    void assertIllegal(String s) {
        junit.framework.Assert.assertFalse((String)s, (boolean)Strings.isLegalUtf16(s));
    }

    @Test
    public void testSharedPrefixLength() {
        this.testPref("", "", 0);
        this.testPref("a", "", 0);
        this.testPref("", "a", 0);
        this.testPref("a", "a", 1);
        this.testPref("ab", "a", 1);
        this.testPref("a", "ab", 1);
        this.testPref("abc", "abcd", 3);
        this.testPref("abcdefg", "abc", 3);
        this.testPref("bcd", "cde", 0);
    }

    void testPref(String a, String b, int expectedVal) {
        junit.framework.Assert.assertEquals((int)expectedVal, (int)Strings.sharedPrefixLength(a, b));
    }

    @Test
    public void testHashCode() {
        this.testHashCode("");
        this.testHashCode("abc");
        this.testHashCode("xyz kdkdkpq984yuro8iuz");
    }

    void testHashCode(String input) {
        int expectedHash = input.hashCode();
        junit.framework.Assert.assertEquals((int)expectedHash, (int)Strings.hashCode(input));
        StringBuilder sb = new StringBuilder();
        sb.append(input);
        junit.framework.Assert.assertEquals((int)expectedHash, (int)Strings.hashCode(sb));
        char[] cs = input.toCharArray();
        CharBuffer buf = CharBuffer.wrap(cs);
        junit.framework.Assert.assertEquals((int)expectedHash, (int)Strings.hashCode(buf));
    }

    @Test
    public void testReverse() {
        this.assertReverse("", "");
        this.assertReverse("a", "a");
        this.assertReverse("ab", "ba");
        this.assertReverse("abc", "cba");
    }

    void assertReverse(String x, String xRev) {
        junit.framework.Assert.assertEquals((String)xRev, (String)Strings.reverse(x));
    }

    @Test
    public void testUTF8IsSupported() {
        boolean threw = false;
        try {
            new String(new byte[]{97}, Strings.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            threw = true;
        }
        junit.framework.Assert.assertFalse((boolean)threw);
    }

    @Test
    public void testAllLetters() {
        junit.framework.Assert.assertTrue((boolean)Strings.allLetters("abc".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.allLetters("".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.allLetters("abc1".toCharArray()));
    }

    @Test
    public void testAllUpperCase() {
        junit.framework.Assert.assertTrue((boolean)Strings.allUpperCase("ABC".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.allUpperCase("".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.allUpperCase("ABC1".toCharArray()));
    }

    @Test
    public void testCapitalized() {
        junit.framework.Assert.assertFalse((boolean)Strings.capitalized("".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.capitalized("Abc".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.capitalized("Abc1".toCharArray()));
    }

    @Test
    public void testContainsDigits() {
        junit.framework.Assert.assertTrue((boolean)Strings.containsDigits("123".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.containsDigits("".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.containsDigits("abc1".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.containsDigits("abc".toCharArray()));
    }

    @Test
    public void testContainsLetter() {
        junit.framework.Assert.assertTrue((boolean)Strings.containsLetter("abc".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.containsLetter("".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.containsLetter("abc1".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.containsLetter("123".toCharArray()));
    }

    @Test
    public void testAllPunctuation() {
        junit.framework.Assert.assertTrue((boolean)Strings.allPunctuation(";..?!".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.allPunctuation("".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.allPunctuation("\".".toCharArray()));
    }

    @Test
    public void testAllPunctuationString() {
        junit.framework.Assert.assertTrue((boolean)Strings.allPunctuation(";..?!"));
        junit.framework.Assert.assertTrue((boolean)Strings.allPunctuation(""));
        junit.framework.Assert.assertFalse((boolean)Strings.allPunctuation("\"."));
    }

    @Test
    public void testAllSymbols() {
        junit.framework.Assert.assertTrue((boolean)Strings.allSymbols(";..?!".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.allSymbols("".toCharArray()));
        junit.framework.Assert.assertTrue((boolean)Strings.allSymbols("\".".toCharArray()));
        junit.framework.Assert.assertFalse((boolean)Strings.allSymbols("$%^&*abc".toCharArray()));
    }

    @Test
    public void testContainsChar() {
        junit.framework.Assert.assertTrue((boolean)Strings.containsChar("abc", 'a'));
        junit.framework.Assert.assertTrue((boolean)Strings.containsChar("abc", 'b'));
        junit.framework.Assert.assertTrue((boolean)Strings.containsChar("abc", 'c'));
        junit.framework.Assert.assertFalse((boolean)Strings.containsChar("abc", 'd'));
        junit.framework.Assert.assertFalse((boolean)Strings.containsChar("", 'a'));
    }

    @Test
    public void testAllWhitespace() {
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace(""));
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace(" \n \t"));
        junit.framework.Assert.assertFalse((boolean)Strings.allWhitespace("  a  "));
    }

    @Test
    public void testAllWhitespaceSB() {
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace(new StringBuilder("")));
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace(new StringBuilder(" \n \t")));
        junit.framework.Assert.assertFalse((boolean)Strings.allWhitespace(new StringBuilder("  a  ")));
    }

    @Test
    public void testAllWhitespaceArray() {
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace("".toCharArray(), 0, 0));
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace(" \n \t ".toCharArray(), 0, 3));
        junit.framework.Assert.assertTrue((boolean)Strings.allWhitespace("     a  ".toCharArray(), 1, 2));
        junit.framework.Assert.assertFalse((boolean)Strings.allWhitespace("     a  ".toCharArray(), 3, 3));
    }

    @Test
    public void testAllDigits() {
        junit.framework.Assert.assertTrue((boolean)Strings.allDigits(""));
        junit.framework.Assert.assertTrue((boolean)Strings.allDigits("123"));
        junit.framework.Assert.assertFalse((boolean)Strings.allDigits("1.23"));
        junit.framework.Assert.assertFalse((boolean)Strings.allDigits("1ab"));
    }

    @Test
    public void testAllDigitsArray() {
        junit.framework.Assert.assertTrue((boolean)Strings.allDigits("".toCharArray(), 0, 0));
        junit.framework.Assert.assertTrue((boolean)Strings.allDigits("123".toCharArray(), 0, 3));
        junit.framework.Assert.assertFalse((boolean)Strings.allDigits("1.23".toCharArray(), 0, 4));
        junit.framework.Assert.assertFalse((boolean)Strings.allDigits("1ab".toCharArray(), 0, 3));
    }

    @Test
    public void testIsWhitespace() {
        junit.framework.Assert.assertTrue((boolean)Strings.isWhitespace('\u00a0'));
        junit.framework.Assert.assertTrue((boolean)Strings.isWhitespace(' '));
        junit.framework.Assert.assertTrue((boolean)Strings.isWhitespace('\n'));
        junit.framework.Assert.assertFalse((boolean)Strings.isWhitespace('a'));
    }

    @Test
    public void testIsPunctuation() {
        junit.framework.Assert.assertTrue((boolean)Strings.isPunctuation('!'));
        junit.framework.Assert.assertTrue((boolean)Strings.isPunctuation('?'));
        junit.framework.Assert.assertTrue((boolean)Strings.isPunctuation(';'));
        junit.framework.Assert.assertFalse((boolean)Strings.isPunctuation('\"'));
        junit.framework.Assert.assertFalse((boolean)Strings.isPunctuation('a'));
    }

    @Test
    public void testPower() {
        junit.framework.Assert.assertEquals((String)"", (String)Strings.power("abc", 0));
        junit.framework.Assert.assertEquals((String)"", (String)Strings.power("", 3));
        junit.framework.Assert.assertEquals((String)"aaa", (String)Strings.power("a", 3));
    }

    @Test
    public void testConcatenateObjectArray() {
        junit.framework.Assert.assertEquals((String)"a b", (String)Strings.concatenate(new Object[]{"a", "b"}));
        junit.framework.Assert.assertEquals((String)"a b c", (String)Strings.concatenate(new Object[]{"a", "b", "c"}));
        junit.framework.Assert.assertEquals((String)"", (String)Strings.concatenate(new Object[0]));
    }

    @Test
    public void testConcatenateObjectArraySpacer() {
        junit.framework.Assert.assertEquals((String)"a,b", (String)Strings.concatenate(new Object[]{"a", "b"}, ","));
        junit.framework.Assert.assertEquals((String)"abc", (String)Strings.concatenate(new Object[]{"a", "b", "c"}, ""));
        junit.framework.Assert.assertEquals((String)"", (String)Strings.concatenate(new Object[0], " "));
    }

    @Test
    public void testConcatenateObjectArrayStartSpacer() {
        junit.framework.Assert.assertEquals((String)"a,b", (String)Strings.concatenate(new Object[]{"a", "b"}, 0, ","));
        junit.framework.Assert.assertEquals((String)"abc", (String)Strings.concatenate(new Object[]{"e", "a", "b", "c"}, 1, ""));
        junit.framework.Assert.assertEquals((String)"", (String)Strings.concatenate(new Object[0], 15, " "));
    }

    @Test
    public void testConcatenateObjectArrayStartEndSpacer() {
        junit.framework.Assert.assertEquals((String)"a,b", (String)Strings.concatenate(new Object[]{"a", "b"}, 0, 2, ","));
        junit.framework.Assert.assertEquals((String)"abc", (String)Strings.concatenate(new Object[]{"e", "a", "b", "c", "f"}, 1, 4, ""));
    }

    @Test
    public void testIndent() {
        StringBuilder sb = new StringBuilder();
        Strings.indent(sb, 3);
        junit.framework.Assert.assertEquals((String)sb.toString(), (String)"\n   ");
        sb = new StringBuilder();
        Strings.indent(sb, 0);
        junit.framework.Assert.assertEquals((String)sb.toString(), (String)"\n");
    }

    @Test
    public void testPadding() {
        junit.framework.Assert.assertEquals((String)"", (String)Strings.padding(0));
        junit.framework.Assert.assertEquals((String)"  ", (String)Strings.padding(2));
    }

    @Test
    public void testPaddingSB() {
        StringBuilder sb = new StringBuilder();
        Strings.padding(sb, 0);
        junit.framework.Assert.assertEquals((String)"", (String)sb.toString());
        sb = new StringBuilder();
        Strings.padding(sb, 2);
        junit.framework.Assert.assertEquals((String)"  ", (String)sb.toString());
    }

    @Test
    public void testFunctionArgs() {
        junit.framework.Assert.assertEquals((String)"a()", (String)Strings.functionArgs("a", new Object[0]));
        junit.framework.Assert.assertEquals((String)"a(1)", (String)Strings.functionArgs("a", new Object[]{1}));
        junit.framework.Assert.assertEquals((String)"a(1,b)", (String)Strings.functionArgs("a", new Object[]{1, "b"}));
    }

    @Test
    public void testArgsList() {
        junit.framework.Assert.assertEquals((String)"()", (String)Strings.functionArgsList(new Object[0]));
        junit.framework.Assert.assertEquals((String)"(a)", (String)Strings.functionArgsList(new Object[]{"a"}));
        junit.framework.Assert.assertEquals((String)"(a,b)", (String)Strings.functionArgsList(new Object[]{"a", "b"}));
    }

    @Test
    public void testTitleCase() {
        junit.framework.Assert.assertEquals((String)"", (String)Strings.titleCase(""));
        junit.framework.Assert.assertEquals((String)"A", (String)Strings.titleCase("a"));
        junit.framework.Assert.assertEquals((String)"1ab", (String)Strings.titleCase("1ab"));
        junit.framework.Assert.assertEquals((String)"Abc", (String)Strings.titleCase("abc"));
    }

    @Test
    public void testConstants() {
        junit.framework.Assert.assertEquals((int)160, (int)Strings.NBSP_CHAR);
        junit.framework.Assert.assertEquals((char)'\n', (char)Strings.NEWLINE_CHAR);
        junit.framework.Assert.assertEquals((char)' ', (char)Strings.DEFAULT_SEPARATOR_CHAR);
        junit.framework.Assert.assertEquals((String)" ", (String)Strings.DEFAULT_SEPARATOR_STRING);
    }

    @Test
    public void testSplit() {
        Assert.assertArrayEquals((Object[])new String[]{""}, (Object[])Strings.split("", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])Strings.split("a", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"a", ""}, (Object[])Strings.split("a ", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"", "a"}, (Object[])Strings.split(" a", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"", "a", ""}, (Object[])Strings.split(" a ", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"", "aa", ""}, (Object[])Strings.split(" aa ", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])Strings.split("a b", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])Strings.split("a b c", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"aaa"}, (Object[])Strings.split("aaa", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"aaa", "bb"}, (Object[])Strings.split("aaa bb", ' '));
        Assert.assertArrayEquals((Object[])new String[]{"aaa", "bb", "c"}, (Object[])Strings.split("aaa bb c", ' '));
    }

    @Test
    public void testMsToString() {
        junit.framework.Assert.assertEquals((String)":00", (String)Strings.msToString(0L));
        junit.framework.Assert.assertEquals((String)":00", (String)Strings.msToString(999L));
        junit.framework.Assert.assertEquals((String)":01", (String)Strings.msToString(1001L));
        junit.framework.Assert.assertEquals((String)":32", (String)Strings.msToString(32000L));
        junit.framework.Assert.assertEquals((String)"1:01", (String)Strings.msToString(61000L));
        junit.framework.Assert.assertEquals((String)"3:12:03", (String)Strings.msToString(11523000L));
        junit.framework.Assert.assertEquals((String)"33:00:00", (String)Strings.msToString(118800000L));
    }

    @Test
    public void testNormalizeWhitespace() {
        this.assertWhitespaceNormalized("abc", "abc");
        this.assertWhitespaceNormalized("abc de fg", " abc de  \t fg\n\n");
        this.assertWhitespaceNormalized("a b", " a\tb\n");
        this.assertWhitespaceNormalized("a b", "a\t\t\t b");
        this.assertWhitespaceNormalized("", "");
        this.assertWhitespaceNormalized("", " ");
    }

    private void assertWhitespaceNormalized(String expected, String input) {
        StringBuilder sb = new StringBuilder();
        Strings.normalizeWhitespace(input, sb);
        junit.framework.Assert.assertEquals((String)expected, (String)sb.toString());
    }

    @Test
    public void testEqualsCharSeqs() {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        junit.framework.Assert.assertTrue((boolean)Strings.equalCharSequence(sb1, sb2));
        sb1.append("abc");
        junit.framework.Assert.assertFalse((boolean)Strings.equalCharSequence(sb1, sb2));
        junit.framework.Assert.assertTrue((boolean)Strings.equalCharSequence("abc", sb1));
    }

    @Test
    public void testTextPositions() {
        this.assertTextPositions("", "");
        this.assertTextPositions("a", "a\n0");
        this.assertTextPositions("ab", "ab\n01");
        this.assertTextPositions("abcdefghi", "abcdefghi\n012345678");
        this.assertTextPositions("abcdefghijklm", "abcdefghijklm\n0123456789012\n0         1  ");
    }

    void assertTextPositions(String in, String expected) {
        String found = Strings.textPositions(in);
        junit.framework.Assert.assertEquals((String)expected, (String)found);
    }
}

