/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public class BooleanFieldHandler
implements CmdOptionHandler {
    private final String[] trueWords;
    private final String[] falseWords;
    private final boolean caseSensitive;

    public BooleanFieldHandler() {
        this(new String[]{"on", "true", "1"}, new String[]{"off", "false", "0"}, false);
    }

    public BooleanFieldHandler(String[] trueWords, String[] falseWords, boolean caseSensitive) {
        this.trueWords = trueWords;
        this.falseWords = falseWords;
        this.caseSensitive = caseSensitive;
    }

    public boolean canHandle(AccessibleObject element, int argCount) {
        if (element instanceof Field && argCount == 1) {
            Field field = (Field)element;
            return field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE);
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        String arg = args[0];
        if (!this.caseSensitive) {
            arg = arg.toLowerCase();
        }
        Boolean decission = null;
        for (String word : this.trueWords) {
            if (!arg.equals(this.caseSensitive ? word : word.toLowerCase())) continue;
            decission = true;
            break;
        }
        if (decission == null) {
            if (this.falseWords == null || this.falseWords.length == 0) {
                decission = false;
            } else {
                for (String word : this.falseWords) {
                    if (!arg.equals(this.caseSensitive ? word : word.toLowerCase())) continue;
                    decission = false;
                    break;
                }
            }
        }
        if (decission == null) {
            throw new CmdOptionHandlerException("Could not parse argument '" + args[0] + "' as boolean parameter.");
        }
        try {
            Field field = (Field)element;
            field.set(config, decission);
        }
        catch (Exception e) {
            throw new CmdOptionHandlerException("Could not apply argument '" + args[0] + "'.", e);
        }
    }
}

