/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantClass;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.FieldSignature;

public class MULTIANEWARRAY
extends VoidOperation {
    public static final int OP = 197;
    private int index = -1;
    private int dimensions = -1;
    static /* synthetic */ Class class$java$lang$Object;

    public MULTIANEWARRAY(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
        this.dimensions = dataInput.readUnsignedByte();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        ConstantClass constant = (ConstantClass)constantPool[this.index];
        Class clazz = null;
        try {
            clazz = constant.getValue().getClassValue();
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
        int[] dimensions = new int[this.dimensions];
        for (int i = dimensions.length - 1; i >= 0; --i) {
            dimensions[i] = Primitive.toInteger((Object)stack.pop());
        }
        try {
            Class componentType = FieldSignature.toClass((String)clazz.getName().replaceAll("\\[", ""));
            Object result = this.newArray(0, dimensions, componentType);
            stack.push(result);
        }
        catch (ClassNotFoundException exception) {
            throw new InterpreterException(exception);
        }
    }

    private Object newArray(int depth, int[] dimensions, Class clazz) {
        try {
            if (depth == dimensions.length) {
                if (clazz.isPrimitive()) {
                    throw new InterpreterException("may not occur");
                }
                return clazz.newInstance();
            }
            if (depth == dimensions.length - 1 && clazz.isPrimitive()) {
                return Array.newInstance(clazz, dimensions[depth]);
            }
            Object arrayref = Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = MULTIANEWARRAY.class$("java.lang.Object")) : class$java$lang$Object, dimensions[depth]);
            for (int i = 0; i < dimensions[depth]; ++i) {
                Array.set(arrayref, i, this.newArray(depth + 1, dimensions, clazz));
            }
            return arrayref;
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public int getByteLength() {
        return 4;
    }

    public int getOpcode() {
        return 197;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

