/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.ServiceLoaderGeneratorSource;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import edu.berkeley.cs.jqf.fuzz.Fuzz;
import edu.berkeley.cs.jqf.fuzz.difffuzz.Comparison;
import edu.berkeley.cs.jqf.fuzz.difffuzz.DiffFuzz;
import edu.berkeley.cs.jqf.fuzz.difffuzz.DiffFuzzGuidance;
import edu.berkeley.cs.jqf.fuzz.difffuzz.DiffFuzzNoGuidance;
import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.fuzz.junit.quickcheck.FuzzStatement;
import edu.berkeley.cs.jqf.fuzz.random.NoGuidance;
import edu.berkeley.cs.jqf.fuzz.repro.ReproGuidance;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JQF
extends JUnitQuickcheck {
    protected final GeneratorRepository generatorRepository;
    Map<String, FrameworkMethod> cmpNames;

    public JQF(Class<?> clazz) throws InitializationError {
        super(clazz);
        SourceOfRandomness randomness = new SourceOfRandomness(new Random(42L));
        this.generatorRepository = new GeneratorRepository(randomness).register((Iterable)new ServiceLoaderGeneratorSource());
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List methods = super.computeTestMethods();
        methods.addAll(this.getTestClass().getAnnotatedMethods(Fuzz.class));
        methods.addAll(this.getTestClass().getAnnotatedMethods(DiffFuzz.class));
        return methods;
    }

    protected void validateTestMethods(List<Throwable> errors) {
        super.validateTestMethods(errors);
        this.validateFuzzMethods(errors);
        this.cmpNames = new HashMap<String, FrameworkMethod>();
        this.validateComparisonMethods(errors);
        this.validateRegressionMethods(errors);
    }

    private void validateFuzzMethods(List<Throwable> errors) {
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Fuzz.class)) {
            method.validatePublicVoid(false, errors);
            if (method.getAnnotation(Property.class) == null) continue;
            errors.add(new Exception("Method " + method.getName() + " cannot have both @Property and @Fuzz annotations"));
        }
    }

    private void validateComparisonMethods(List<Throwable> errors) {
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Comparison.class)) {
            Class<?>[] parameters;
            if (method.getReturnType() != Boolean.class) {
                errors.add(new Exception("Method " + method.getName() + " must return Boolean"));
            }
            if ((parameters = method.getMethod().getParameterTypes()).length != 2 || parameters[0] != parameters[1]) {
                errors.add(new Exception("Method " + method.getName() + " must have exactly two parameters, and they must be of the same type"));
            }
            this.cmpNames.put(method.getName(), method);
        }
    }

    private void validateRegressionMethods(List<Throwable> errors) {
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(DiffFuzz.class)) {
            String cmp;
            if (method.getReturnType() == null) {
                errors.add(new Exception("Method " + method.getName() + " cannot be void"));
            }
            if (!method.isPublic()) {
                errors.add(new Exception("Method " + method.getName() + " must be public"));
            }
            if (method.isStatic()) {
                errors.add(new Exception("Method " + method.getName() + " must not be static"));
            }
            if (!(cmp = ((DiffFuzz)method.getAnnotation(DiffFuzz.class)).cmp()).equals("") && !this.cmpNames.containsKey(cmp)) {
                errors.add(new Exception("cmp() in Diff annotation of method " + method.getName() + " must be the name of a function in this class marked with the @Comparison annotation"));
                continue;
            }
            if (cmp.equals("") || this.cmpNames.get(cmp).getMethod().getParameterTypes()[0] == method.getReturnType()) continue;
            errors.add(new Exception("The function referred to by cmp() in Regression annotation of method " + String.valueOf(method) + " must accept arguments matching the return type of the method"));
        }
    }

    public Statement methodBlock(FrameworkMethod method) {
        if (method.getAnnotation(Fuzz.class) != null) {
            Guidance guidance = GuidedFuzzing.getCurrentGuidance();
            if (guidance == null) {
                String repro = ((Fuzz)method.getAnnotation(Fuzz.class)).repro();
                if (repro.isEmpty()) {
                    long maxTrials = Long.getLong("jqf.quickcheck.trials", GuidedFuzzing.DEFAULT_MAX_TRIALS);
                    guidance = new NoGuidance(maxTrials, System.err);
                } else {
                    String reproPath;
                    if (repro.matches("\\$\\{[a-zA-Z.\\d_$]*\\}")) {
                        String key = repro.substring(2, repro.length() - 1);
                        String val = System.getProperty(key);
                        if (val == null) {
                            throw new IllegalArgumentException(String.format("Test method has @Fuzz annotation with repro=%s, but such a system property is not set. Use `-D%s=<path>` when running.", repro, key));
                        }
                        reproPath = val;
                    } else {
                        reproPath = repro;
                    }
                    File inputFile = new File(reproPath);
                    try {
                        guidance = new ReproGuidance(inputFile, null);
                    }
                    catch (IOException e) {
                        throw new GuidanceException(String.format("Could not open repro file: %s", inputFile.getAbsolutePath()), e);
                    }
                }
            }
            return new FuzzStatement(method, this.getTestClass(), this.generatorRepository, guidance);
        }
        if (method.getAnnotation(DiffFuzz.class) != null) {
            Guidance guidance = GuidedFuzzing.getCurrentGuidance();
            if (guidance == null) {
                guidance = new DiffFuzzNoGuidance(GuidedFuzzing.DEFAULT_MAX_TRIALS, System.err);
            }
            if (!(guidance instanceof DiffFuzzGuidance)) {
                throw new IllegalStateException("@DiffFuzz methods cannot be fuzzed with a " + guidance.getClass().getName());
            }
            DiffFuzzGuidance diffGuidance = (DiffFuzzGuidance)guidance;
            if (!((DiffFuzz)method.getAnnotation(DiffFuzz.class)).cmp().isEmpty()) {
                diffGuidance.setCompare(this.cmpNames.get(((DiffFuzz)method.getAnnotation(DiffFuzz.class)).cmp()).getMethod());
            }
            return new FuzzStatement(method, this.getTestClass(), this.generatorRepository, diffGuidance);
        }
        return super.methodBlock(method);
    }
}

