/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.afl;

import edu.berkeley.cs.jqf.fuzz.afl.AFLGuidance;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.Hashing;
import edu.berkeley.cs.jqf.fuzz.util.MapOfCounters;
import edu.berkeley.cs.jqf.instrument.tracing.events.AllocEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.ReadEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.ReturnEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.collections.api.list.primitive.IntList;

public class PerfFuzzGuidance
extends AFLGuidance {
    protected static final int PERF_MAP_SIZE = 16384;
    protected Counter branchCounts = new Counter(16383);
    protected int totalBranchCount;
    protected Counter allocCounts = new Counter(16383);
    protected MapOfCounters memoryAccesses = new MapOfCounters(16383, 6151);
    protected CallingContext callingContext = new CallingContext();
    private final PerfFeedbackType perfFeedbackType;
    private PrintWriter scores = new PrintWriter(new FileOutputStream("scores.log"), true);
    boolean optimized = true;

    public PerfFuzzGuidance(File inputFile, File inPipe, File outPipe) throws IOException {
        super(inputFile, inPipe, outPipe);
        this.perfFeedbackType = PerfFeedbackType.valueOf(System.getProperty("jqf.afl.perfFeedbackType", "BRANCH_COUNTS"));
        System.out.println((Object)this.perfFeedbackType);
    }

    public PerfFuzzGuidance(String inputFileName, String inPipeName, String outPipeName) throws IOException {
        this(new File(inputFileName), new File(inPipeName), new File(outPipeName));
    }

    @Override
    public InputStream getInput() {
        this.memoryAccesses.clear();
        this.branchCounts.clear();
        this.allocCounts.clear();
        this.totalBranchCount = 0;
        assert (this.callingContext.isEmpty());
        return super.getInput();
    }

    @Override
    protected void handleEvent(TraceEvent e) {
        if (e instanceof BranchEvent) {
            BranchEvent b = (BranchEvent)e;
            int edgeId = 1 + Hashing.hash1(b.getIid(), b.getArm(), Short.MAX_VALUE);
            this.incrementTraceBits(edgeId);
            this.branchCounts.increment(edgeId);
            ++this.totalBranchCount;
            this.checkForTimeouts();
        } else if (e instanceof ReadEvent) {
            ReadEvent read = (ReadEvent)e;
            if (this.perfFeedbackType == PerfFeedbackType.REDUNDANCY_SCORES) {
                int memoryLocation = this.hashMemorylocation(read.getObjectId(), read.getField());
                int aec = this.getAyclicExecutionContextForEvent((TraceEvent)read);
                this.memoryAccesses.increment(aec, memoryLocation);
            }
        } else if (e instanceof CallEvent) {
            this.callingContext.push((CallEvent)e);
            int edgeId = 1 + Hashing.hash(e.getIid(), Short.MAX_VALUE);
            this.incrementTraceBits(edgeId);
        } else if (e instanceof ReturnEvent) {
            this.callingContext.pop();
        } else if (e instanceof AllocEvent) {
            AllocEvent alloc = (AllocEvent)e;
            if (this.perfFeedbackType == PerfFeedbackType.ALLOCATION_COUNTS) {
                int size = alloc.getSize();
                this.allocCounts.increment(alloc.getIid(), size);
            }
        }
    }

    private void putTotalBranchCountIntoFeedback() {
        this.feedback.putInt(0, this.totalBranchCount);
    }

    @Override
    public void handleResult(Result result, Throwable error) {
        super.handleResult(result, error);
        while (!this.callingContext.isEmpty()) {
        }
        this.clearFeedbackBuffer();
        switch (this.perfFeedbackType.ordinal()) {
            case 2: {
                this.putTotalBranchCountIntoFeedback();
                break;
            }
            case 0: {
                for (int cidx = 0; cidx < 16384; ++cidx) {
                    int discreteScore;
                    double redundancyScore = PerfFuzzGuidance.computeRedundancyScore(this.memoryAccesses.nonZeroCountsAtIndex(cidx));
                    int n = discreteScore = redundancyScore > 0.0 ? PerfFuzzGuidance.discretizeScore(redundancyScore) : 0;
                    assert (discreteScore >= 0 && discreteScore <= Integer.MAX_VALUE);
                    this.feedback.putInt(cidx * 4, discreteScore);
                }
                this.putTotalBranchCountIntoFeedback();
                break;
            }
            case 1: {
                assert (this.branchCounts.size() == 16383);
                for (int k = 0; k < this.branchCounts.size(); ++k) {
                    this.feedback.putInt((k + 1) * 4, this.branchCounts.getAtIndex(k));
                }
                this.putTotalBranchCountIntoFeedback();
                break;
            }
            case 3: {
                assert (this.allocCounts.size() == 16383);
                for (int k = 0; k < this.allocCounts.size(); ++k) {
                    this.feedback.putInt((k + 1) * 4, this.allocCounts.getAtIndex(k));
                }
                break;
            }
        }
        try {
            this.proxyOutput.write(this.feedback.array(), 0, 65536);
            this.proxyOutput.flush();
        }
        catch (IOException e) {
            this.everything_ok = false;
        }
    }

    protected int hashMemorylocation(int objectId, String field) {
        return field.hashCode() * 31 + objectId;
    }

    protected int getAyclicExecutionContextForEvent(TraceEvent e) {
        int aecHash = this.optimized ? this.callingContext.fastComputeAecHash(e) : this.callingContext.computeAcyclicExecutionContextHash(e);
        return aecHash;
    }

    public static double computeRedundancyScore(IntList accessCounts) {
        double numCounts = accessCounts.size();
        if (numCounts == 0.0) {
            return 0.0;
        }
        double sumCounts = 0.0;
        sumCounts = accessCounts.sum();
        double averageCounts = sumCounts / numCounts;
        double score = (averageCounts - 1.0) * (numCounts - 1.0) / sumCounts;
        return score;
    }

    public static int discretizeScore(double score) {
        return (int)Math.round(2.147483647E9 * (Math.pow(2.0, score) - 1.0));
    }

    protected class CallingContext {
        Map<String, Frame> firstInvocations = new HashMap<String, Frame>();
        Deque<Frame> callStack = new ArrayDeque<Frame>();
        private volatile boolean empty = true;

        protected CallingContext() {
        }

        public void push(CallEvent callEvent) {
            Frame frame = new Frame(callEvent, this.callStack.peek());
            String methodName = callEvent.getInvokedMethodName();
            if (!this.firstInvocations.containsKey(methodName)) {
                this.firstInvocations.put(methodName, frame);
                frame.firstInvocation = true;
                if (frame.parent != null) {
                    String callingMethod = frame.parent.call.getInvokedMethodName();
                    frame.precomputeAecHash(this.firstInvocations.get(callingMethod));
                }
            }
            this.callStack.push(frame);
            this.empty = false;
        }

        public void pop() {
            Frame frame = this.callStack.pop();
            if (frame.firstInvocation) {
                this.firstInvocations.remove(frame.call.getInvokedMethodName());
            }
            assert (this.callStack.size() >= this.firstInvocations.size());
            if (this.callStack.size() == 0) {
                this.empty = true;
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public String getExecutionContext(TraceEvent e) {
            assert (!this.callStack.isEmpty());
            Object str = "";
            for (Frame frame : this.callStack) {
                str = (String)str + String.format("%s(%s:%d)\n", this.trimMethodNameOfDesc(frame.call.getInvokedMethodName()), e.getFileName(), e.getLineNumber());
                e = frame.call;
            }
            return str;
        }

        public String getAcyclicExecutionContext(TraceEvent e) {
            assert (!this.callStack.isEmpty());
            Object str = "";
            Frame frame = this.callStack.peek();
            while (frame != null) {
                str = (String)str + String.format("%s(%s:%d)\n", this.trimMethodNameOfDesc(frame.call.getInvokedMethodName()), e.getFileName(), e.getLineNumber());
                Frame firstInvocationFrame = this.firstInvocations.get(frame.call.getInvokedMethodName());
                e = firstInvocationFrame.call;
                frame = firstInvocationFrame.parent;
            }
            return str;
        }

        public int fastComputeAecHash(TraceEvent e) {
            assert (!this.callStack.isEmpty());
            Frame top = this.callStack.peek();
            Frame firstInvocationOfTopMethod = this.firstInvocations.get(top.call.getInvokedMethodName());
            return firstInvocationOfTopMethod.aecHash * 31 + e.getIid();
        }

        public int computeAcyclicExecutionContextHash(TraceEvent e) {
            assert (!this.callStack.isEmpty());
            Frame frame = this.callStack.peek();
            ArrayDeque<Integer> iids = new ArrayDeque<Integer>();
            while (frame != null) {
                iids.addFirst(e.getIid());
                Frame firstInvocationFrame = this.firstInvocations.get(frame.call.getInvokedMethodName());
                e = firstInvocationFrame.call;
                frame = firstInvocationFrame.parent;
            }
            int hash = 0;
            Iterator iterator = iids.iterator();
            while (iterator.hasNext()) {
                int iid = (Integer)iterator.next();
                hash = 31 * hash + iid;
            }
            return hash;
        }

        private String trimMethodNameOfDesc(String methodName) {
            return methodName.substring(0, methodName.indexOf(40));
        }

        protected class Frame {
            final CallEvent call;
            final Frame parent;
            boolean firstInvocation;
            int aecHash;

            Frame(CallEvent call, Frame parent) {
                this.call = call;
                this.parent = parent;
            }

            void precomputeAecHash(Frame acyclicParent) {
                this.aecHash = acyclicParent.aecHash * 31 + this.call.getIid();
            }
        }
    }

    public static enum PerfFeedbackType {
        REDUNDANCY_SCORES,
        BRANCH_COUNTS,
        TOTAL_BRANCH_COUNT,
        ALLOCATION_COUNTS;

    }
}

