/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.difffuzz;

import edu.berkeley.cs.jqf.fuzz.difffuzz.DiffException;
import edu.berkeley.cs.jqf.fuzz.difffuzz.DiffFuzzGuidance;
import edu.berkeley.cs.jqf.fuzz.difffuzz.Outcome;
import edu.berkeley.cs.jqf.fuzz.difffuzz.Serializer;
import edu.berkeley.cs.jqf.fuzz.repro.ReproGuidance;
import edu.berkeley.cs.jqf.fuzz.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class DiffFuzzReproGuidance
extends ReproGuidance
implements DiffFuzzGuidance {
    private Method compare;
    protected List<Outcome> cmpTo = null;
    public static final List<Outcome> recentOutcomes = new ArrayList<Outcome>();

    public DiffFuzzReproGuidance(File[] inputFile, File traceDir) throws IOException {
        super(inputFile, traceDir);
        recentOutcomes.clear();
        try {
            this.compare = Objects.class.getMethod("equals", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public DiffFuzzReproGuidance(File[] inputFile, File traceDir, List<Outcome> cmpRes) throws IOException {
        this(inputFile, traceDir);
        this.cmpTo = cmpRes;
    }

    public DiffFuzzReproGuidance(File inputFile, File traceDir) throws IOException {
        this(IOUtils.resolveInputFileOrDirectory(inputFile), traceDir);
    }

    public DiffFuzzReproGuidance(File inputFile, File traceDir, List<Outcome> cmpRes) throws IOException {
        this(IOUtils.resolveInputFileOrDirectory(inputFile), traceDir, cmpRes);
    }

    @Override
    public void setCompare(Method m) {
        this.compare = m;
    }

    @Override
    public void run(TestClass testClass, FrameworkMethod method, Object[] args) throws Throwable {
        Outcome outSerial;
        Outcome out = this.getOutcome(testClass.getJavaClass(), method, args);
        recentOutcomes.add(out);
        if (this.cmpTo == null) {
            if (out.thrown != null) {
                throw out.thrown;
            }
            return;
        }
        Outcome cmpOut = this.cmpTo.get(recentOutcomes.size() - 1);
        ClassLoader cmpCL = this.compare.getDeclaringClass().getClassLoader();
        Outcome cmpSerial = new Outcome(Serializer.translate(cmpOut.output, cmpCL), cmpOut.thrown);
        if (!Outcome.same(cmpSerial, outSerial = new Outcome(Serializer.translate(out.output, cmpCL), out.thrown), this.compare)) {
            throw new DiffException(this.cmpTo.get(recentOutcomes.size() - 1), out);
        }
    }
}

