/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.difffuzz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class Serializer {
    public static Object[] translate(Object[] original, ClassLoader newCL) throws IOException, ClassNotFoundException {
        return Serializer.deserialize(Serializer.serialize(original), newCL, original);
    }

    public static Object translate(Object original, ClassLoader newCL) throws IOException, ClassNotFoundException {
        Object[] arr = new Object[]{original};
        return Serializer.deserialize(Serializer.serialize(arr), newCL, arr)[0];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object[] items) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(out);){
                for (Object item : items) {
                    if (item == null) continue;
                    oos.writeObject(item);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Object[] deserialize(byte[] bytes, final ClassLoader cl, Object[] original) throws ClassNotFoundException, IOException {
        Object[] objectArray;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes)){

            @Override
            public Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(osc.getName(), true, cl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.resolveClass(osc);
                }
            }
        };
        try {
            Object[] itemArr = new Object[original.length];
            for (int c = 0; c < original.length; ++c) {
                if (original[c] != null) {
                    itemArr[c] = ois.readObject();
                    continue;
                }
                original[c] = null;
            }
            objectArray = itemArr;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                throw e;
            }
        }
        ois.close();
        return objectArray;
    }
}

