/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import java.util.Arrays;

public class ExecutionIndex
implements Comparable<ExecutionIndex> {
    final int[] ei;
    private final int hash;

    public ExecutionIndex(int[] ei) {
        if (ei.length == 0 || ei.length % 2 == 1) {
            throw new IllegalArgumentException("Execution index must have non-zero even elements");
        }
        this.ei = ei;
        this.hash = Arrays.hashCode(this.ei);
    }

    public ExecutionIndex(Prefix prefix, Suffix suffix) {
        if (prefix.length != suffix.offset) {
            throw new IllegalArgumentException("Invalid prefix/suffix combo");
        }
        int size = ((Suffix)suffix).ei.ei.length;
        this.ei = new int[size];
        int[] prefixEi = ((Prefix)prefix).ei.ei;
        for (int i = 0; i < prefix.length; ++i) {
            this.ei[i] = prefixEi[i];
        }
        int[] suffixEi = ((Suffix)suffix).ei.ei;
        for (int i = suffix.offset; i < size; ++i) {
            this.ei[i] = suffixEi[i];
        }
        this.hash = Arrays.hashCode(this.ei);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ExecutionIndex) {
            return Arrays.equals(this.ei, ((ExecutionIndex)other).ei);
        }
        return false;
    }

    @Override
    public int compareTo(ExecutionIndex other) {
        int len1 = this.ei.length;
        int len2 = other.ei.length;
        int lim = Math.min(len1, len2);
        int[] v1 = this.ei;
        int[] v2 = other.ei;
        for (int k = 0; k < lim; ++k) {
            int c1 = v1[k];
            int c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public String toString() {
        return Arrays.toString(this.ei);
    }

    public int oneSuffixSize() {
        int size = 0;
        for (int i = this.ei.length - 1; i >= 0; i -= 2) {
            if (this.ei[i] != 1) continue;
            ++size;
        }
        return size;
    }

    public Suffix getCommonSuffix(ExecutionIndex other) {
        int offset;
        if (this.ei.length != other.ei.length) {
            throw new IllegalArgumentException("Common suffix can only be computed on execution indexes with same execution contexts");
        }
        for (offset = this.ei.length; offset > 0 && this.ei[offset - 2] == other.ei[offset - 2] && this.ei[offset - 1] == other.ei[offset - 1]; offset -= 2) {
        }
        return new Suffix(this, offset);
    }

    public Prefix getPrefixOfSuffix(Suffix suffix) {
        return new Prefix(this, suffix.offset);
    }

    public Suffix getSuffixOfPrefix(Prefix prefix) {
        return new Suffix(this, prefix.length);
    }

    public boolean hasPrefix(Prefix prefix) {
        int[] cmpEi = ((Prefix)prefix).ei.ei;
        for (int i = 0; i < prefix.length; ++i) {
            if (this.ei[i] == cmpEi[i]) continue;
            return false;
        }
        return true;
    }

    public static class Prefix {
        private final ExecutionIndex ei;
        private final int length;

        public Prefix(ExecutionIndex ei, int length) {
            this.ei = ei;
            this.length = length;
        }

        public int size() {
            return this.length / 2;
        }

        public ExecutionIndex getEi() {
            return this.ei;
        }
    }

    public static class Suffix {
        private final ExecutionIndex ei;
        private final int offset;

        public Suffix(ExecutionIndex ei, int offset) {
            this.ei = ei;
            this.offset = offset;
        }

        public int size() {
            return (this.ei.ei.length - this.offset) / 2;
        }

        public ExecutionIndex getEi() {
            return this.ei;
        }
    }
}

