/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import edu.berkeley.cs.jqf.fuzz.ei.ExecutionIndexingGuidance;
import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import java.io.File;
import java.util.Random;

public class ExecutionIndexingDriver {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java " + String.valueOf(ExecutionIndexingDriver.class) + " TEST_CLASS TEST_METHOD [OUTPUT_DIR [SEEDS...]]");
            System.exit(1);
        }
        String testClassName = args[0];
        String testMethodName = args[1];
        String outputDirectoryName = args.length > 2 ? args[2] : "fuzz-results";
        File outputDirectory = new File(outputDirectoryName);
        File[] seedFiles = null;
        if (args.length > 3) {
            seedFiles = new File[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                seedFiles[i - 3] = new File(args[i]);
            }
        }
        try {
            String title = testClassName + "#" + testMethodName;
            ExecutionIndexingGuidance guidance = seedFiles == null ? new ExecutionIndexingGuidance(title, null, null, outputDirectory, new Random()) : (seedFiles.length == 1 && seedFiles[0].isDirectory() ? new ExecutionIndexingGuidance(title, null, null, outputDirectory, seedFiles[0], new Random()) : new ExecutionIndexingGuidance(title, null, null, outputDirectory, seedFiles, new Random()));
            System.setProperty("jqf.traceGenerators", "true");
            GuidedFuzzing.run(testClassName, testMethodName, (Guidance)guidance, System.out);
            if (Boolean.getBoolean("jqf.logCoverage")) {
                System.out.println(String.format("Covered %d edges.", guidance.getTotalCoverage().getNonZeroCount()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

