/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import edu.berkeley.cs.jqf.fuzz.ei.ExecutionContext;
import edu.berkeley.cs.jqf.fuzz.ei.ExecutionIndex;
import edu.berkeley.cs.jqf.fuzz.ei.ZestGuidance;
import edu.berkeley.cs.jqf.fuzz.ei.state.AbstractExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.ei.state.FastExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.ei.state.JanalaExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.util.CoverageFactory;
import edu.berkeley.cs.jqf.fuzz.util.IOUtils;
import edu.berkeley.cs.jqf.fuzz.util.ProducerHashMap;
import edu.berkeley.cs.jqf.instrument.tracing.FastCoverageSnoop;
import edu.berkeley.cs.jqf.instrument.tracing.SingleSnoop;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import janala.instrument.FastCoverageListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class ExecutionIndexingGuidance
extends ZestGuidance {
    protected AbstractExecutionIndexingState eiState;
    private Map<ExecutionContext, ArrayList<InputLocation>> ecToInputLoc = new ProducerHashMap<ExecutionContext, ArrayList>(() -> new ArrayList());
    protected Thread appThread;
    protected String entryPoint;
    protected boolean testEntered;
    protected Map<Integer, Integer> coverageHashToSavedInputIdx = new HashMap<Integer, Integer>();
    protected final double MEAN_MUTATION_COUNT = 8.0;
    protected final double MEAN_MUTATION_SIZE = 4.0;
    protected final int MAX_SPLICE_SIZE = 64;
    protected final boolean SPLICE_SUBTREE = Boolean.getBoolean("jqf.ei.SPLICE_SUBTREE");
    protected final double STANDARD_SPLICING_PROBABILITY = 0.5;
    protected final double DEMAND_DRIVEN_SPLICING_PROBABILITY = 0.0;

    public ExecutionIndexingGuidance(String testName, Duration duration, Long trials, File outputDirectory, Random sourceOfRandomness) throws IOException {
        super(testName, duration, trials, outputDirectory, sourceOfRandomness);
    }

    public ExecutionIndexingGuidance(String testName, Duration duration, Long trials, File outputDirectory, File seedInputDir, Random sourceOfRandomness) throws IOException {
        this(testName, duration, trials, outputDirectory, IOUtils.resolveInputFileOrDirectory(seedInputDir), sourceOfRandomness);
    }

    public ExecutionIndexingGuidance(String testName, Duration duration, Long trials, File outputDirectory, File[] seedFiles, Random sourceOfRandomness) throws IOException {
        super(testName, duration, trials, outputDirectory, new File[0], sourceOfRandomness);
        if (seedFiles != null) {
            for (File seedFile : seedFiles) {
                this.seedInputs.add(new MappedSeedInput(seedFile));
            }
        }
    }

    @Override
    protected String getTitle() {
        if (this.blind) {
            return super.getTitle();
        }
        return "Semantic Fuzzing with Execution Indexes\n---------------------------------------\n";
    }

    @Override
    protected ZestGuidance.Input<?> createFreshInput() {
        return new MappedInput();
    }

    @Override
    protected InputStream createParameterStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (ExecutionIndexingGuidance.this.eiState.getLastEventIid() == -1) {
                    throw new GuidanceException("Could not compute execution index; no instrumentation?");
                }
                assert (ExecutionIndexingGuidance.this.currentInput instanceof MappedInput) : "This guidance should only mutate MappedInput(s)";
                MappedInput mappedInput = (MappedInput)ExecutionIndexingGuidance.this.currentInput;
                ExecutionIndex executionIndex = ExecutionIndexingGuidance.this.eiState.getExecutionIndex(ExecutionIndexingGuidance.this.eiState.getLastEventIid());
                int value = mappedInput.getOrGenerateFresh(executionIndex, ExecutionIndexingGuidance.this.random);
                return value;
            }
        };
    }

    @Override
    public InputStream getInput() throws GuidanceException {
        this.eiState = CoverageFactory.newEIState();
        if (this.eiState instanceof FastExecutionIndexingState) {
            FastCoverageSnoop.setFastCoverageListener((FastCoverageListener)((FastCoverageListener)this.eiState));
        }
        this.testEntered = false;
        return super.getInput();
    }

    @Override
    public void run(TestClass testClass, FrameworkMethod method, Object[] args) throws Throwable {
        if (this.runCoverage instanceof FastCoverageListener) {
            FastCoverageSnoop.setFastCoverageListener((FastCoverageListener)((FastCoverageListener)this.runCoverage));
        }
        super.run(testClass, method, args);
    }

    @Override
    public void handleResult(Result result, Throwable error) throws GuidanceException {
        int numSavedInputsBefore = this.savedInputs.size();
        super.handleResult(result, error);
        if (result == Result.SUCCESS) {
            int coverageHash = this.runCoverage.hashCode();
            if (this.savedInputs.size() > numSavedInputsBefore) {
                assert (numSavedInputsBefore == this.savedInputs.size() - 1) : "savedInputs can only grow by 1 at a time";
                this.coverageHashToSavedInputIdx.put(coverageHash, numSavedInputsBefore);
            } else if (this.coverageHashToSavedInputIdx.containsKey(coverageHash)) {
                int otherIdx = this.coverageHashToSavedInputIdx.get(coverageHash);
                ZestGuidance.Input otherInput = (ZestGuidance.Input)this.savedInputs.get(otherIdx);
                this.currentInput.gc();
                if (otherInput != null && this.currentInput.size() < otherInput.size()) {
                    this.infoLog("Minimzation successful! Replacing input %d with %s (size %d ==> %d bytes)", otherIdx, this.currentInput.desc, otherInput.size(), this.currentInput.size());
                    this.savedInputs.set(otherIdx, this.currentInput);
                    MutableIntIterator otherResponsibilitiesIter = otherInput.responsibilities.intIterator();
                    while (otherResponsibilitiesIter.hasNext()) {
                        int b = otherResponsibilitiesIter.next();
                        this.responsibleInputs.put(b, this.currentInput);
                    }
                    this.currentInput.responsibilities = otherInput.responsibilities;
                    this.currentInput.id = otherIdx;
                    this.currentInput.saveFile = otherInput.saveFile;
                    this.currentInput.coverage = this.runCoverage.copy();
                    this.currentInput.nonZeroCoverage = this.runCoverage.getNonZeroCount();
                    this.currentInput.offspring = 0;
                    ++((ZestGuidance.Input)this.savedInputs.get((int)this.currentParentInputIdx)).offspring;
                    try {
                        this.writeCurrentInputToFile(this.currentInput.saveFile);
                    }
                    catch (IOException e) {
                        throw new GuidanceException(e);
                    }
                }
            }
        }
    }

    @Override
    protected void saveCurrentInput(IntHashSet responsibilities, String why) throws IOException {
        super.saveCurrentInput(responsibilities, why);
        this.mapEcToInputLoc(this.currentInput);
    }

    @Override
    protected void completeCycle() {
        super.completeCycle();
        this.ecToInputLoc.clear();
        for (ZestGuidance.Input input : this.savedInputs) {
            if (!input.isFavored()) continue;
            this.mapEcToInputLoc(input);
        }
    }

    private void mapEcToInputLoc(ZestGuidance.Input input) {
        if (input instanceof MappedInput) {
            MappedInput mappedInput = (MappedInput)input;
            for (int offset = 0; offset < mappedInput.size(); ++offset) {
                ExecutionIndex ei = mappedInput.orderedKeys.get(offset);
                ExecutionContext ec = new ExecutionContext(ei);
                this.ecToInputLoc.get(ec).add(new InputLocation(mappedInput, offset));
            }
        }
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        if (this.appThread != null) {
            throw new IllegalStateException(String.valueOf(ExecutionIndexingGuidance.class) + " only supports single-threaded apps at the moment");
        }
        this.appThread = thread;
        this.entryPoint = ((String)SingleSnoop.entryPoints.get(thread)).replace('.', '/');
        assert (this.entryPoint != null) : String.valueOf(ExecutionIndexingGuidance.class) + " must be able to determine an entry point";
        return this::handleEvent;
    }

    @Override
    protected void handleEvent(TraceEvent e) {
        if (this.eiState instanceof JanalaExecutionIndexingState) {
            e.applyVisitor((TraceEventVisitor)((JanalaExecutionIndexingState)this.eiState));
        }
        if (!this.testEntered) {
            CallEvent callEvent;
            if (e instanceof CallEvent && (callEvent = (CallEvent)e).getInvokedMethodName().startsWith(this.entryPoint)) {
                this.testEntered = true;
            }
            if (!this.testEntered) {
                return;
            }
        }
        super.handleEvent(e);
    }

    public class MappedSeedInput
    extends MappedInput {
        final File seedFile;
        final InputStream in;

        public MappedSeedInput(File seedFile) throws IOException {
            this.seedFile = seedFile;
            this.in = new BufferedInputStream(new FileInputStream(seedFile));
            this.desc = "seed";
        }

        @Override
        public int getOrGenerateFresh(ExecutionIndex key, Random random) {
            int value;
            try {
                value = this.in.read();
            }
            catch (IOException e) {
                throw new GuidanceException("Error reading from seed file: " + this.seedFile.getName(), e);
            }
            if (value == -1) {
                if (ExecutionIndexingGuidance.this.GENERATE_EOF_WHEN_OUT) {
                    return -1;
                }
                value = random.nextInt(256);
            }
            this.orderedKeys.add(key);
            this.valuesMap.put(key, value);
            return value;
        }

        @Override
        public void gc() {
            this.executed = true;
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new GuidanceException("Error closing seed file:" + this.seedFile.getName(), e);
            }
        }
    }

    public class MappedInput
    extends ZestGuidance.Input<ExecutionIndex> {
        protected boolean executed;
        protected LinkedHashMap<ExecutionIndex, Integer> valuesMap;
        protected ArrayList<ExecutionIndex> orderedKeys;
        private List<InputPrefixMapping> demandDrivenSpliceMap;

        public MappedInput() {
            this.executed = false;
            this.orderedKeys = new ArrayList();
            this.demandDrivenSpliceMap = new ArrayList<InputPrefixMapping>();
            this.valuesMap = new LinkedHashMap();
        }

        public MappedInput(MappedInput toClone) {
            super(toClone);
            this.executed = false;
            this.orderedKeys = new ArrayList();
            this.demandDrivenSpliceMap = new ArrayList<InputPrefixMapping>();
            this.valuesMap = new LinkedHashMap<ExecutionIndex, Integer>(toClone.valuesMap);
        }

        @Override
        public final int size() {
            return this.valuesMap.size();
        }

        private final int getValueAtOffset(int offset) throws IndexOutOfBoundsException, IllegalStateException {
            if (!this.executed) {
                throw new IllegalStateException("Cannot get with offset before execution");
            }
            ExecutionIndex ei = this.orderedKeys.get(offset);
            return this.valuesMap.get(ei);
        }

        private final ExecutionIndex getKeyAtOffset(int offset) throws IndexOutOfBoundsException, IllegalStateException {
            if (!this.executed) {
                throw new IllegalStateException("Cannot get with offset before execution");
            }
            return this.orderedKeys.get(offset);
        }

        private InputPrefixMapping getInputPrefixMapping(ExecutionIndex ei) {
            for (InputPrefixMapping ipm : this.demandDrivenSpliceMap) {
                if (!ei.hasPrefix(ipm.targetPrefix)) continue;
                return ipm;
            }
            return null;
        }

        @Override
        public int getOrGenerateFresh(ExecutionIndex key, Random random) throws IllegalStateException {
            if (this.executed) {
                throw new IllegalStateException("Cannot generate fresh values after execution");
            }
            if (this.orderedKeys.size() >= ExecutionIndexingGuidance.this.MAX_INPUT_SIZE) {
                return -1;
            }
            Integer val = this.valuesMap.get(key);
            if (val == null) {
                InputPrefixMapping ipm = this.getInputPrefixMapping(key);
                if (ipm != null) {
                    ExecutionIndex.Prefix sourcePrefix = ipm.sourcePrefix;
                    ExecutionIndex.Suffix sourceSuffix = ipm.sourcePrefix.getEi().getSuffixOfPrefix(sourcePrefix);
                    ExecutionIndex sourceEi = new ExecutionIndex(sourcePrefix, sourceSuffix);
                    val = ipm.sourceInput.getValueAtKey(sourceEi);
                }
                if (val == null) {
                    if (ExecutionIndexingGuidance.this.GENERATE_EOF_WHEN_OUT) {
                        return -1;
                    }
                    if (!(random.nextDouble() < 0.0)) {
                        val = random.nextInt(256);
                    }
                }
                assert (val != null);
                this.valuesMap.put(key, val);
            }
            this.orderedKeys.add(key);
            return val;
        }

        protected final Integer getValueAtKey(ExecutionIndex ei) throws IndexOutOfBoundsException {
            return this.valuesMap.get(ei);
        }

        protected final void setValueAtKey(ExecutionIndex ei, int val) throws IndexOutOfBoundsException, IllegalStateException {
            if (this.executed) {
                throw new IllegalStateException("Cannot set value before execution");
            }
            this.valuesMap.put(ei, val);
        }

        @Override
        public void gc() {
            LinkedHashMap<ExecutionIndex, Integer> newMap = new LinkedHashMap<ExecutionIndex, Integer>();
            for (ExecutionIndex key : this.orderedKeys) {
                newMap.put(key, this.valuesMap.get(key));
            }
            this.valuesMap = newMap;
            assert (this.valuesMap.size() == this.orderedKeys.size()) : "valuesMap and orderedKeys must be of same size";
            this.executed = true;
        }

        @Override
        public ZestGuidance.Input fuzz(Random random) {
            return this.fuzz(random, ExecutionIndexingGuidance.this.ecToInputLoc);
        }

        protected MappedInput fuzz(Random random, Map<ExecutionContext, ArrayList<InputLocation>> ecToInputLoc) {
            MappedInput newInput = new MappedInput(this);
            boolean splicingDone = false;
            if (ecToInputLoc != null && random.nextDouble() < 0.5) {
                int MIN_TARGET_ATTEMPTS = 3;
                int MAX_TARGET_ATTEMPTS = 6;
                int targetAttempts = 3;
                block0: for (int targetAttempt = 1; targetAttempt < targetAttempts; ++targetAttempt) {
                    int targetOffset = random.nextInt(newInput.valuesMap.size());
                    ExecutionIndex targetEi = this.getKeyAtOffset(targetOffset);
                    ExecutionContext targetEc = new ExecutionContext(targetEi);
                    int valueAtTarget = this.getValueAtOffset(targetOffset);
                    List inputLocations = ecToInputLoc.get(targetEc).stream().filter(it -> ((InputLocation)it).input != this).collect(Collectors.toList());
                    if (inputLocations.size() == 0) {
                        targetAttempts = Math.min(targetAttempts + 1, 6);
                        continue;
                    }
                    for (int attempt = 1; attempt <= 10; ++attempt) {
                        InputLocation inputLocation = (InputLocation)inputLocations.get(random.nextInt(inputLocations.size()));
                        MappedInput sourceInput = inputLocation.input;
                        int sourceOffset = inputLocation.offset;
                        if (sourceInput == this || sourceInput.getValueAtOffset(sourceOffset) == valueAtTarget) continue;
                        int splicedBytes = 0;
                        if (ExecutionIndexingGuidance.this.SPLICE_SUBTREE) {
                            ExecutionIndex candidateEi;
                            int srcIdx;
                            ExecutionIndex sourceEi = sourceInput.getKeyAtOffset(sourceOffset);
                            ExecutionIndex.Suffix suffix = targetEi.getCommonSuffix(sourceEi);
                            if (suffix.size() == 0) continue;
                            ExecutionIndex.Prefix sourcePrefix = sourceEi.getPrefixOfSuffix(suffix);
                            ExecutionIndex.Prefix targetPrefix = targetEi.getPrefixOfSuffix(suffix);
                            assert (sourcePrefix.size() == targetPrefix.size());
                            this.demandDrivenSpliceMap.add(new InputPrefixMapping(sourceInput, sourcePrefix, targetPrefix));
                            for (srcIdx = sourceOffset; srcIdx < sourceInput.size() && (candidateEi = sourceInput.getKeyAtOffset(srcIdx)).hasPrefix(sourcePrefix); ++srcIdx) {
                                ExecutionIndex.Suffix spliceSuffix = candidateEi.getSuffixOfPrefix(sourcePrefix);
                                ExecutionIndex spliceEi = new ExecutionIndex(targetPrefix, spliceSuffix);
                                newInput.valuesMap.put(spliceEi, sourceInput.valuesMap.get(candidateEi));
                            }
                            splicedBytes = srcIdx - sourceOffset;
                        } else {
                            int spliceSize = 1 + random.nextInt(64);
                            int src = sourceOffset;
                            int srcSize = sourceInput.size();
                            int tgtSize = newInput.size();
                            for (int tgt = targetOffset; splicedBytes < spliceSize && src < srcSize && tgt < tgtSize; ++splicedBytes, ++src, ++tgt) {
                                int val = sourceInput.getValueAtOffset(src);
                                ExecutionIndex key = this.getKeyAtOffset(tgt);
                                newInput.setValueAtKey(key, val);
                            }
                        }
                        splicingDone = true;
                        newInput.desc = newInput.desc + String.format(",splice:%06d:%d@%d->%d", sourceInput.id, splicedBytes, sourceOffset, targetOffset);
                        break block0;
                    }
                }
            }
            if (!splicingDone || random.nextBoolean()) {
                int numMutations = MappedInput.sampleGeometric(random, 8.0);
                newInput.desc = newInput.desc + ",havoc:" + numMutations;
                block4: for (int mutation = 1; mutation <= numMutations; ++mutation) {
                    boolean setToZero;
                    int offset = random.nextInt(newInput.valuesMap.size());
                    int mutationSize = MappedInput.sampleGeometric(random, 4.0);
                    newInput.desc = newInput.desc + String.format("(%d@%d)", mutationSize, offset);
                    boolean bl = setToZero = random.nextDouble() < 0.1;
                    if (setToZero) {
                        newInput.desc = newInput.desc + "=0";
                    }
                    Iterator<Map.Entry<ExecutionIndex, Integer>> entryIterator = newInput.valuesMap.entrySet().iterator();
                    ExecutionContext ecToMutate = null;
                    int i = 0;
                    while (entryIterator.hasNext()) {
                        Map.Entry<ExecutionIndex, Integer> e = entryIterator.next();
                        if (i >= offset && i < offset + mutationSize) {
                            ExecutionContext currentEc = new ExecutionContext(e.getKey());
                            if (ecToMutate == null) {
                                ecToMutate = currentEc;
                            } else if (!ecToMutate.equals(currentEc)) continue block4;
                            int mutatedValue = setToZero ? 0 : random.nextInt(256);
                            e.setValue(mutatedValue);
                        }
                        ++i;
                    }
                }
            }
            return newInput;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                Iterator<ExecutionIndex> keyIt;
                {
                    this.keyIt = MappedInput.this.orderedKeys.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.keyIt.hasNext();
                }

                @Override
                public Integer next() {
                    return MappedInput.this.valuesMap.get(this.keyIt.next());
                }
            };
        }
    }

    static class InputLocation {
        private final MappedInput input;
        private final int offset;

        InputLocation(MappedInput input, int offset) {
            this.input = input;
            this.offset = offset;
        }
    }

    static class InputPrefixMapping {
        private final MappedInput sourceInput;
        private final ExecutionIndex.Prefix sourcePrefix;
        private final ExecutionIndex.Prefix targetPrefix;

        InputPrefixMapping(MappedInput sourceInput, ExecutionIndex.Prefix sourcePrefix, ExecutionIndex.Prefix targetPrefix) {
            this.sourceInput = sourceInput;
            this.sourcePrefix = sourcePrefix;
            this.targetPrefix = targetPrefix;
        }
    }
}

