/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.guidance.TimeoutException;
import edu.berkeley.cs.jqf.fuzz.util.Coverage;
import edu.berkeley.cs.jqf.fuzz.util.CoverageFactory;
import edu.berkeley.cs.jqf.fuzz.util.FastNonCollidingCoverage;
import edu.berkeley.cs.jqf.fuzz.util.ICoverage;
import edu.berkeley.cs.jqf.fuzz.util.IOUtils;
import edu.berkeley.cs.jqf.instrument.tracing.FastCoverageSnoop;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import janala.instrument.FastCoverageListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public class ZestGuidance
implements Guidance {
    protected final double MUTATION_ZERO_PROBABILITY = 0.1;
    protected Random random;
    protected final String testName;
    protected final long maxDurationMillis;
    protected final long maxTrials;
    protected long numTrials = 0L;
    protected long numValid = 0L;
    protected final File outputDirectory;
    protected File savedCorpusDirectory;
    protected File savedFailuresDirectory;
    protected File allInputsDirectory;
    protected ArrayList<Input> savedInputs = new ArrayList();
    protected Deque<Input> seedInputs = new ArrayDeque<Input>();
    protected Input<?> currentInput;
    protected int currentParentInputIdx = 0;
    protected int numChildrenGeneratedForCurrentParentInput = 0;
    protected int cyclesCompleted = 0;
    protected int numFavoredLastCycle = 0;
    protected boolean blind;
    protected boolean validityFuzzing;
    protected int numSavedInputs = 0;
    protected ICoverage runCoverage = CoverageFactory.newInstance();
    protected ICoverage totalCoverage = CoverageFactory.newInstance();
    protected ICoverage validCoverage = CoverageFactory.newInstance();
    protected int maxCoverage = 0;
    protected Map<Object, Input> responsibleInputs = new HashMap<Object, Input>(this.totalCoverage.size());
    protected Set<String> uniqueFailures = new HashSet<String>();
    protected final String EXACT_CRASH_PATH = System.getProperty("jqf.ei.EXACT_CRASH_PATH");
    protected final boolean verbose = true;
    protected final Console console = System.console();
    protected final Date startTime;
    protected Date lastRefreshTime = this.startTime = new Date();
    protected long lastNumTrials = 0L;
    protected final long STATS_REFRESH_TIME_PERIOD = 300L;
    protected File logFile;
    protected File statsFile;
    protected File currentInputFile;
    protected File coverageFile;
    protected final boolean LIBFUZZER_COMPAT_OUTPUT = Boolean.getBoolean("jqf.ei.LIBFUZZER_COMPAT_OUTPUT");
    protected final boolean QUIET_MODE = Boolean.getBoolean("jqf.ei.QUIET_MODE");
    protected final boolean LOG_ALL_INPUTS = Boolean.getBoolean("jqf.ei.LOG_ALL_INPUTS");
    protected long singleRunTimeoutMillis;
    protected Date runStart;
    protected long branchCount;
    protected final boolean EXIT_ON_CRASH = Boolean.getBoolean("jqf.ei.EXIT_ON_CRASH");
    protected Thread firstThread;
    protected boolean multiThreaded = false;
    protected final boolean SAVE_ONLY_VALID = Boolean.getBoolean("jqf.ei.SAVE_ONLY_VALID");
    protected final int MAX_INPUT_SIZE = Integer.getInteger("jqf.ei.MAX_INPUT_SIZE", 10240);
    protected final boolean GENERATE_EOF_WHEN_OUT = Boolean.getBoolean("jqf.ei.GENERATE_EOF_WHEN_OUT");
    protected final int NUM_CHILDREN_BASELINE = 50;
    protected final int NUM_CHILDREN_MULTIPLIER_FAVORED = 20;
    protected final double MEAN_MUTATION_COUNT = 8.0;
    protected final double MEAN_MUTATION_SIZE = 4.0;
    protected final boolean DISABLE_SAVE_NEW_COUNTS = Boolean.getBoolean("jqf.ei.DISABLE_SAVE_NEW_COUNTS");
    protected final boolean STEAL_RESPONSIBILITY = Boolean.getBoolean("jqf.ei.STEAL_RESPONSIBILITY");
    private static MessageDigest sha1;

    public ZestGuidance(String testName, Duration duration, Long trials, File outputDirectory, Random sourceOfRandomness) throws IOException {
        String timeout;
        this.random = sourceOfRandomness;
        this.testName = testName;
        this.maxDurationMillis = duration != null ? duration.toMillis() : Long.MAX_VALUE;
        this.maxTrials = trials != null ? trials : Long.MAX_VALUE;
        this.outputDirectory = outputDirectory;
        this.blind = Boolean.getBoolean("jqf.ei.TOTALLY_RANDOM");
        this.validityFuzzing = !Boolean.getBoolean("jqf.ei.DISABLE_VALIDITY_FUZZING");
        this.prepareOutputDirectory();
        if (this.runCoverage instanceof FastCoverageListener) {
            FastCoverageSnoop.setFastCoverageListener((FastCoverageListener)((FastCoverageListener)this.runCoverage));
        }
        if ((timeout = System.getProperty("jqf.ei.TIMEOUT")) != null && !timeout.isEmpty()) {
            try {
                this.singleRunTimeoutMillis = Long.parseLong(timeout);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Invalid timeout duration: " + timeout);
            }
        }
    }

    public ZestGuidance(String testName, Duration duration, Long trials, File outputDirectory, File[] seedInputFiles, Random sourceOfRandomness) throws IOException {
        this(testName, duration, trials, outputDirectory, sourceOfRandomness);
        if (seedInputFiles != null) {
            for (File seedInputFile : seedInputFiles) {
                this.seedInputs.add(new SeedInput(seedInputFile));
            }
        }
    }

    public ZestGuidance(String testName, Duration duration, Long trials, File outputDirectory, File seedInputDir, Random sourceOfRandomness) throws IOException {
        this(testName, duration, trials, outputDirectory, IOUtils.resolveInputFileOrDirectory(seedInputDir), sourceOfRandomness);
    }

    public ZestGuidance(String testName, Duration duration, File outputDirectory, File seedInputDir) throws IOException {
        this(testName, duration, null, outputDirectory, seedInputDir, new Random());
    }

    public ZestGuidance(String testName, Duration duration, File outputDirectory) throws IOException {
        this(testName, duration, null, outputDirectory, new Random());
    }

    public ZestGuidance(String testName, Duration duration, File outputDirectory, File[] seedFiles) throws IOException {
        this(testName, duration, null, outputDirectory, seedFiles, new Random());
    }

    private void prepareOutputDirectory() throws IOException {
        IOUtils.createDirectory(this.outputDirectory);
        this.savedCorpusDirectory = IOUtils.createDirectory(this.outputDirectory, "corpus");
        this.savedFailuresDirectory = IOUtils.createDirectory(this.outputDirectory, "failures");
        if (this.LOG_ALL_INPUTS) {
            this.allInputsDirectory = IOUtils.createDirectory(this.outputDirectory, "all");
            IOUtils.createDirectory(this.allInputsDirectory, "success");
            IOUtils.createDirectory(this.allInputsDirectory, "invalid");
            IOUtils.createDirectory(this.allInputsDirectory, "failure");
        }
        this.statsFile = new File(this.outputDirectory, "plot_data");
        this.logFile = new File(this.outputDirectory, "fuzz.log");
        this.currentInputFile = new File(this.outputDirectory, ".cur_input");
        this.coverageFile = new File(this.outputDirectory, "coverage_hash");
        this.statsFile.delete();
        this.logFile.delete();
        this.coverageFile.delete();
        for (File file : this.savedCorpusDirectory.listFiles()) {
            file.delete();
        }
        for (File file : this.savedFailuresDirectory.listFiles()) {
            file.delete();
        }
        this.appendLineToFile(this.statsFile, this.getStatNames());
    }

    protected String getStatNames() {
        return "# unix_time, cycles_done, cur_path, paths_total, pending_total, pending_favs, map_size, unique_crashes, unique_hangs, max_depth, execs_per_sec, valid_inputs, invalid_inputs, valid_cov, all_covered_probes, valid_covered_probes";
    }

    protected void appendLineToFile(File file, String line) throws GuidanceException {
        try (PrintWriter out = new PrintWriter(new FileWriter(file, true));){
            out.println(line);
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
    }

    @Override
    public String observeGuidance() {
        if (this.blind) {
            return "Random";
        }
        return "Zest";
    }

    protected void infoLog(String str, Object ... args) {
        String line = String.format(str, args);
        if (this.logFile != null) {
            this.appendLineToFile(this.logFile, line);
        } else {
            System.err.println(line);
        }
    }

    protected String millisToDuration(long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis % TimeUnit.MINUTES.toMillis(1L));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis % TimeUnit.HOURS.toMillis(1L));
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        Object result = "";
        if (hours > 0L) {
            result = hours + "h ";
        }
        if (hours > 0L || minutes > 0L) {
            result = (String)result + minutes + "m ";
        }
        result = (String)result + seconds + "s";
        return result;
    }

    protected void displayStats(boolean force) {
        Object currentParentInputDesc;
        Date now = new Date();
        long intervalMilliseconds = now.getTime() - this.lastRefreshTime.getTime();
        if ((intervalMilliseconds = Math.max(1L, intervalMilliseconds)) < 300L && !force) {
            return;
        }
        long interlvalTrials = this.numTrials - this.lastNumTrials;
        long intervalExecsPerSec = interlvalTrials * 1000L;
        double intervalExecsPerSecDouble = (double)interlvalTrials * 1000.0;
        if (intervalMilliseconds != 0L) {
            intervalExecsPerSec = interlvalTrials * 1000L / intervalMilliseconds;
            intervalExecsPerSecDouble = (double)interlvalTrials * 1000.0 / (double)intervalMilliseconds;
        }
        this.lastRefreshTime = now;
        this.lastNumTrials = this.numTrials;
        long elapsedMilliseconds = now.getTime() - this.startTime.getTime();
        elapsedMilliseconds = Math.max(1L, elapsedMilliseconds);
        long execsPerSec = this.numTrials * 1000L / elapsedMilliseconds;
        if (this.seedInputs.size() > 0 || this.savedInputs.isEmpty()) {
            currentParentInputDesc = "<seed>";
        } else {
            Input currentParentInput = this.savedInputs.get(this.currentParentInputIdx);
            currentParentInputDesc = this.currentParentInputIdx + " ";
            currentParentInputDesc = (String)currentParentInputDesc + (currentParentInput.isFavored() ? "(favored)" : "(not favored)");
            currentParentInputDesc = (String)currentParentInputDesc + " {" + this.numChildrenGeneratedForCurrentParentInput + "/" + this.getTargetChildrenForParent(currentParentInput) + " mutations}";
        }
        int nonZeroCount = this.totalCoverage.getNonZeroCount();
        double nonZeroFraction = (double)nonZeroCount * 100.0 / (double)this.totalCoverage.size();
        int nonZeroValidCount = this.validCoverage.getNonZeroCount();
        double nonZeroValidFraction = (double)nonZeroValidCount * 100.0 / (double)this.validCoverage.size();
        if (this.console != null) {
            if (this.LIBFUZZER_COMPAT_OUTPUT) {
                this.console.printf("#%,d\tNEW\tcov: %,d exec/s: %,d L: %,d\n", this.numTrials, nonZeroValidCount, intervalExecsPerSec, this.currentInput.size());
            } else if (!this.QUIET_MODE) {
                this.console.printf("\u001b[2J", new Object[0]);
                this.console.printf("\u001b[H", new Object[0]);
                this.console.printf(this.getTitle() + "\n", new Object[0]);
                if (this.testName != null) {
                    this.console.printf("Test name:            %s\n", this.testName);
                }
                String instrumentationType = "Janala";
                if (this.runCoverage instanceof FastNonCollidingCoverage) {
                    instrumentationType = "Fast";
                }
                this.console.printf("Instrumentation:      %s\n", instrumentationType);
                this.console.printf("Results directory:    %s\n", this.outputDirectory.getAbsolutePath());
                this.console.printf("Elapsed time:         %s (%s)\n", this.millisToDuration(elapsedMilliseconds), this.maxDurationMillis == Long.MAX_VALUE ? "no time limit" : "max " + this.millisToDuration(this.maxDurationMillis));
                this.console.printf("Number of executions: %,d (%s)\n", this.numTrials, this.maxTrials == Long.MAX_VALUE ? "no trial limit" : "max " + this.maxTrials);
                this.console.printf("Valid inputs:         %,d (%.2f%%)\n", this.numValid, (double)this.numValid * 100.0 / (double)this.numTrials);
                this.console.printf("Cycles completed:     %d\n", this.cyclesCompleted);
                this.console.printf("Unique failures:      %,d\n", this.uniqueFailures.size());
                this.console.printf("Queue size:           %,d (%,d favored last cycle)\n", this.savedInputs.size(), this.numFavoredLastCycle);
                this.console.printf("Current parent input: %s\n", currentParentInputDesc);
                this.console.printf("Execution speed:      %,d/sec now | %,d/sec overall\n", intervalExecsPerSec, execsPerSec);
                this.console.printf("Total coverage:       %,d branches (%.2f%% of map)\n", nonZeroCount, nonZeroFraction);
                this.console.printf("Valid coverage:       %,d branches (%.2f%% of map)\n", nonZeroValidCount, nonZeroValidFraction);
            }
        }
        String plotData = String.format("%d, %d, %d, %d, %d, %d, %.2f%%, %d, %d, %d, %.2f, %d, %d, %.2f%%, %d, %d", TimeUnit.MILLISECONDS.toSeconds(now.getTime()), this.cyclesCompleted, this.currentParentInputIdx, this.numSavedInputs, 0, 0, nonZeroFraction, this.uniqueFailures.size(), 0, 0, intervalExecsPerSecDouble, this.numValid, this.numTrials - this.numValid, nonZeroValidFraction, nonZeroCount, nonZeroValidCount);
        this.appendLineToFile(this.statsFile, plotData);
    }

    protected void updateCoverageFile() {
        try {
            PrintWriter pw = new PrintWriter(this.coverageFile);
            pw.println(this.getTotalCoverage().toString());
            pw.println("Hash code: " + this.getTotalCoverage().hashCode());
            pw.close();
        }
        catch (FileNotFoundException ignore) {
            throw new GuidanceException(ignore);
        }
    }

    protected String getTitle() {
        if (this.blind) {
            return "Generator-based random fuzzing (no guidance)\n--------------------------------------------\n";
        }
        return "Semantic Fuzzing with Zest\n--------------------------\n";
    }

    public void setBlind(boolean blind) {
        this.blind = blind;
    }

    protected int getTargetChildrenForParent(Input parentInput) {
        int target = 50;
        if (this.maxCoverage > 0) {
            target = 50 * parentInput.nonZeroCoverage / this.maxCoverage;
        }
        if (parentInput.isFavored()) {
            target *= 20;
        }
        return target;
    }

    protected void completeCycle() {
        ++this.cyclesCompleted;
        this.infoLog("\n# Cycle " + this.cyclesCompleted + " completed.", new Object[0]);
        this.infoLog("Here is a list of favored inputs:", new Object[0]);
        int sumResponsibilities = 0;
        this.numFavoredLastCycle = 0;
        for (Input input : this.savedInputs) {
            if (!input.isFavored()) continue;
            int responsibleFor = input.responsibilities.size();
            this.infoLog("Input %d is responsible for %d branches", input.id, responsibleFor);
            sumResponsibilities += responsibleFor;
            ++this.numFavoredLastCycle;
        }
        int totalCoverageCount = this.totalCoverage.getNonZeroCount();
        this.infoLog("Total %d branches covered", totalCoverageCount);
        if (sumResponsibilities != totalCoverageCount) {
            if (this.multiThreaded) {
                this.infoLog("Warning: other threads are adding coverage between test executions", new Object[0]);
            } else {
                throw new AssertionError((Object)"Responsibilty mismatch");
            }
        }
        this.infoLog("\n\n\n", new Object[0]);
    }

    protected Input<?> createFreshInput() {
        return new LinearInput();
    }

    protected InputStream createParameterStream() {
        return new InputStream(){
            int bytesRead = 0;

            @Override
            public int read() throws IOException {
                assert (ZestGuidance.this.currentInput instanceof LinearInput) : "ZestGuidance should only mutate LinearInput(s)";
                LinearInput linearInput = (LinearInput)ZestGuidance.this.currentInput;
                int ret = linearInput.getOrGenerateFresh(this.bytesRead++, ZestGuidance.this.random);
                return ret;
            }
        };
    }

    @Override
    public InputStream getInput() throws GuidanceException {
        this.conditionallySynchronize(this.multiThreaded, () -> {
            this.runCoverage.clear();
            if (!this.seedInputs.isEmpty()) {
                this.currentInput = this.seedInputs.removeFirst();
            } else if (this.savedInputs.isEmpty()) {
                if (!this.blind && this.numTrials > 100000L) {
                    throw new GuidanceException("Too many trials without coverage; likely all assumption violations");
                }
                this.currentInput = this.createFreshInput();
            } else {
                Input currentParentInput = this.savedInputs.get(this.currentParentInputIdx);
                int targetNumChildren = this.getTargetChildrenForParent(currentParentInput);
                if (this.numChildrenGeneratedForCurrentParentInput >= targetNumChildren) {
                    this.currentParentInputIdx = (this.currentParentInputIdx + 1) % this.savedInputs.size();
                    if (this.currentParentInputIdx == 0) {
                        this.completeCycle();
                    }
                    this.numChildrenGeneratedForCurrentParentInput = 0;
                }
                Input parent = this.savedInputs.get(this.currentParentInputIdx);
                this.currentInput = parent.fuzz(this.random);
                ++this.numChildrenGeneratedForCurrentParentInput;
                try {
                    this.writeCurrentInputToFile(this.currentInputFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.runStart = new Date();
                this.branchCount = 0L;
            }
        });
        return this.createParameterStream();
    }

    @Override
    public boolean hasInput() {
        Date now = new Date();
        long elapsedMilliseconds = now.getTime() - this.startTime.getTime();
        if (this.EXIT_ON_CRASH && this.uniqueFailures.size() >= 1) {
            return false;
        }
        if (elapsedMilliseconds < this.maxDurationMillis && this.numTrials < this.maxTrials) {
            return true;
        }
        this.displayStats(true);
        return false;
    }

    @Override
    public void handleResult(Result result, Throwable error) throws GuidanceException {
        this.conditionallySynchronize(this.multiThreaded, () -> {
            boolean valid;
            this.runStart = null;
            ++this.numTrials;
            boolean bl = valid = result == Result.SUCCESS;
            if (valid) {
                ++this.numValid;
            }
            if (result == Result.SUCCESS || result == Result.INVALID && !this.SAVE_ONLY_VALID) {
                boolean toSave;
                IntHashSet responsibilities = this.computeResponsibilities(valid);
                List<String> savingCriteriaSatisfied = this.checkSavingCriteriaSatisfied(result);
                boolean bl2 = toSave = savingCriteriaSatisfied.size() > 0;
                if (toSave) {
                    String why = String.join((CharSequence)" ", savingCriteriaSatisfied);
                    this.currentInput.gc();
                    assert (this.currentInput.size() > 0) : String.format("Empty input: %s", this.currentInput.desc);
                    if (this.LIBFUZZER_COMPAT_OUTPUT) {
                        this.displayStats(false);
                    }
                    this.infoLog("Saving new input (at run %d): input #%d of size %d; reason = %s", this.numTrials, this.savedInputs.size(), this.currentInput.size(), why);
                    String reason = why;
                    GuidanceException.wrap(() -> this.saveCurrentInput(responsibilities, reason));
                    this.updateCoverageFile();
                }
            } else if (result == Result.FAILURE || result == Result.TIMEOUT) {
                String msg = error.getMessage();
                Throwable rootCause = error;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (this.uniqueFailures.add(ZestGuidance.failureDigest(rootCause.getStackTrace()))) {
                    this.currentInput.gc();
                    assert (this.currentInput.size() > 0) : String.format("Empty input: %s", this.currentInput.desc);
                    int crashIdx = this.uniqueFailures.size() - 1;
                    String saveFileName = String.format("id_%06d", crashIdx);
                    File saveFile = new File(this.savedFailuresDirectory, saveFileName);
                    GuidanceException.wrap(() -> this.writeCurrentInputToFile(saveFile));
                    this.infoLog("%s", "Found crash: " + String.valueOf(error.getClass()) + " - " + (msg != null ? msg : ""));
                    String how = this.currentInput.desc;
                    String why = result == Result.FAILURE ? "+crash" : "+hang";
                    this.infoLog("Saved - %s %s %s", saveFile.getPath(), how, why);
                    if (this.EXACT_CRASH_PATH != null && !this.EXACT_CRASH_PATH.equals("")) {
                        File exactCrashFile = new File(this.EXACT_CRASH_PATH);
                        GuidanceException.wrap(() -> this.writeCurrentInputToFile(exactCrashFile));
                    }
                    if (this.LIBFUZZER_COMPAT_OUTPUT) {
                        this.displayStats(false);
                    }
                }
            }
            if (!this.LIBFUZZER_COMPAT_OUTPUT) {
                this.displayStats(false);
            }
            if (this.LOG_ALL_INPUTS && (!this.SAVE_ONLY_VALID || valid)) {
                File logDirectory = new File(this.allInputsDirectory, result.toString().toLowerCase());
                String saveFileName = String.format("id_%09d", this.numTrials);
                File saveFile = new File(logDirectory, saveFileName);
                GuidanceException.wrap(() -> this.writeCurrentInputToFile(saveFile));
            }
        });
    }

    protected List<String> checkSavingCriteriaSatisfied(Result result) {
        int nonZeroAfter;
        int nonZeroBefore = this.totalCoverage.getNonZeroCount();
        int validNonZeroBefore = this.validCoverage.getNonZeroCount();
        boolean coverageBitsUpdated = this.totalCoverage.updateBits(this.runCoverage);
        if (result == Result.SUCCESS) {
            this.validCoverage.updateBits(this.runCoverage);
        }
        if ((nonZeroAfter = this.totalCoverage.getNonZeroCount()) > this.maxCoverage) {
            this.maxCoverage = nonZeroAfter;
        }
        int validNonZeroAfter = this.validCoverage.getNonZeroCount();
        ArrayList<String> reasonsToSave = new ArrayList<String>();
        if (!this.DISABLE_SAVE_NEW_COUNTS && coverageBitsUpdated) {
            reasonsToSave.add("+count");
        }
        if (nonZeroAfter > nonZeroBefore) {
            reasonsToSave.add("+cov");
        }
        if (this.validityFuzzing && validNonZeroAfter > validNonZeroBefore) {
            reasonsToSave.add("+valid");
        }
        return reasonsToSave;
    }

    protected IntHashSet computeResponsibilities(boolean valid) {
        IntList newValidCoverage;
        IntHashSet result = new IntHashSet();
        IntList newCoverage = this.runCoverage.computeNewCoverage(this.totalCoverage);
        if (newCoverage.size() > 0) {
            result.addAll((IntIterable)newCoverage);
        }
        if (valid && (newValidCoverage = this.runCoverage.computeNewCoverage(this.validCoverage)).size() > 0) {
            result.addAll((IntIterable)newValidCoverage);
        }
        if (this.STEAL_RESPONSIBILITY) {
            int currentNonZeroCoverage = this.runCoverage.getNonZeroCount();
            int currentInputSize = this.currentInput.size();
            IntHashSet covered = new IntHashSet();
            covered.addAll((IntIterable)this.runCoverage.getCovered());
            block0: for (Input candidate : this.savedInputs) {
                IntHashSet responsibilities = candidate.responsibilities;
                if (responsibilities.isEmpty() || candidate.nonZeroCoverage >= currentNonZeroCoverage && (candidate.nonZeroCoverage != currentNonZeroCoverage || currentInputSize >= candidate.size())) continue;
                MutableIntIterator iter = responsibilities.intIterator();
                while (iter.hasNext()) {
                    int b = iter.next();
                    if (covered.contains(b)) continue;
                    continue block0;
                }
                result.addAll((IntIterable)responsibilities);
            }
        }
        return result;
    }

    protected void writeCurrentInputToFile(File saveFile) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(saveFile));){
            for (Integer b : this.currentInput) {
                assert (b >= 0 && b < 256);
                out.write(b);
            }
        }
    }

    protected void saveCurrentInput(IntHashSet responsibilities, String why) throws IOException {
        int newInputIdx = this.numSavedInputs++;
        String saveFileName = String.format("id_%06d", newInputIdx);
        String how = this.currentInput.desc;
        File saveFile = new File(this.savedCorpusDirectory, saveFileName);
        this.writeCurrentInputToFile(saveFile);
        this.infoLog("Saved - %s %s %s", saveFile.getPath(), how, why);
        if (this.blind) {
            return;
        }
        this.savedInputs.add(this.currentInput);
        this.currentInput.id = newInputIdx;
        this.currentInput.saveFile = saveFile;
        this.currentInput.coverage = this.runCoverage.copy();
        this.currentInput.nonZeroCoverage = this.runCoverage.getNonZeroCount();
        this.currentInput.offspring = 0;
        ++this.savedInputs.get((int)this.currentParentInputIdx).offspring;
        this.currentInput.responsibilities = responsibilities;
        if (responsibilities.size() > 0) {
            this.currentInput.setFavored();
        }
        MutableIntIterator iter = responsibilities.intIterator();
        while (iter.hasNext()) {
            int b = iter.next();
            Input oldResponsible = this.responsibleInputs.get(b);
            if (oldResponsible != null) {
                oldResponsible.responsibilities.remove(b);
            }
            this.responsibleInputs.put(b, this.currentInput);
        }
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        if (this.firstThread == null) {
            this.firstThread = thread;
        } else if (this.firstThread != thread) {
            this.multiThreaded = true;
        }
        return this::handleEvent;
    }

    protected void handleEvent(TraceEvent e) {
        this.conditionallySynchronize(this.multiThreaded, () -> {
            long elapsed;
            ((Coverage)this.runCoverage).handleEvent(e);
            if (this.singleRunTimeoutMillis > 0L && this.runStart != null && ++this.branchCount % 10000L == 0L && (elapsed = new Date().getTime() - this.runStart.getTime()) > this.singleRunTimeoutMillis) {
                throw new TimeoutException(elapsed, this.singleRunTimeoutMillis);
            }
        });
    }

    public ICoverage getTotalCoverage() {
        return this.totalCoverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conditionallySynchronize(boolean cond, Runnable task) {
        if (cond) {
            ZestGuidance zestGuidance = this;
            synchronized (zestGuidance) {
                task.run();
            }
        } else {
            task.run();
        }
    }

    private static String failureDigest(StackTraceElement[] stackTrace) {
        if (sha1 == null) {
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new GuidanceException(e);
            }
        }
        byte[] bytes = sha1.digest(Arrays.deepToString(stackTrace).getBytes());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public class SeedInput
    extends LinearInput {
        final File seedFile;
        final InputStream in;

        public SeedInput(File seedFile) throws IOException {
            this.seedFile = seedFile;
            this.in = new BufferedInputStream(new FileInputStream(seedFile));
            this.desc = "seed";
        }

        @Override
        public int getOrGenerateFresh(Integer key, Random random) {
            int value;
            try {
                value = this.in.read();
            }
            catch (IOException e) {
                throw new GuidanceException("Error reading from seed file: " + this.seedFile.getName(), e);
            }
            if (key.intValue() != this.values.size() && value != -1) {
                throw new IllegalStateException(String.format("Bytes from seed out of order. Size = %d, Key = %d", this.values.size(), key));
            }
            if (value >= 0) {
                ++this.requested;
                this.values.add(value);
            }
            return value;
        }

        @Override
        public void gc() {
            super.gc();
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new GuidanceException("Error closing seed file:" + this.seedFile.getName(), e);
            }
        }
    }

    public static abstract class Input<K>
    implements Iterable<Integer> {
        File saveFile = null;
        int id;
        boolean favored;
        String desc;
        ICoverage coverage = null;
        int nonZeroCoverage = -1;
        int offspring = -1;
        IntHashSet responsibilities = null;

        public Input() {
            this.desc = "random";
        }

        public Input(Input toClone) {
            this.desc = String.format("src:%06d", toClone.id);
        }

        public abstract int getOrGenerateFresh(K var1, Random var2);

        public abstract int size();

        public abstract Input fuzz(Random var1);

        public abstract void gc();

        public void setFavored() {
            this.favored = true;
        }

        public boolean isFavored() {
            return this.favored;
        }

        public static int sampleGeometric(Random random, double mean) {
            double p = 1.0 / mean;
            double uniform = random.nextDouble();
            return (int)Math.ceil(Math.log(1.0 - uniform) / Math.log(1.0 - p));
        }
    }

    public class LinearInput
    extends Input<Integer> {
        protected ArrayList<Integer> values;
        protected int requested;

        public LinearInput() {
            this.requested = 0;
            this.values = new ArrayList();
        }

        public LinearInput(LinearInput other) {
            super(other);
            this.requested = 0;
            this.values = new ArrayList<Integer>(other.values);
        }

        @Override
        public int getOrGenerateFresh(Integer key, Random random) {
            if (key != this.requested) {
                throw new IllegalStateException(String.format("Bytes from linear input out of order. Size = %d, Key = %d", this.values.size(), key));
            }
            if (this.requested >= ZestGuidance.this.MAX_INPUT_SIZE) {
                return -1;
            }
            if (key < this.values.size()) {
                ++this.requested;
                return this.values.get(key);
            }
            if (ZestGuidance.this.GENERATE_EOF_WHEN_OUT) {
                return -1;
            }
            int val = random.nextInt(256);
            this.values.add(val);
            ++this.requested;
            return val;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public void gc() {
            this.values = new ArrayList<Integer>(this.values.subList(0, this.requested));
            this.values.trimToSize();
            if (this.values.isEmpty()) {
                throw new IllegalArgumentException("Input is either empty or nothing was requested from the input generator.");
            }
        }

        @Override
        public Input fuzz(Random random) {
            LinearInput newInput = new LinearInput(this);
            int numMutations = LinearInput.sampleGeometric(random, 8.0);
            newInput.desc = newInput.desc + ",havoc:" + numMutations;
            boolean setToZero = random.nextDouble() < 0.1;
            for (int mutation = 1; mutation <= numMutations; ++mutation) {
                int offset = random.nextInt(newInput.values.size());
                int mutationSize = LinearInput.sampleGeometric(random, 4.0);
                for (int i = offset; i < offset + mutationSize && i < newInput.values.size(); ++i) {
                    int mutatedValue = setToZero ? 0 : random.nextInt(256);
                    newInput.values.set(i, mutatedValue);
                }
            }
            return newInput;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.values.iterator();
        }
    }
}

