/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei.state;

import edu.berkeley.cs.jqf.fuzz.ei.ExecutionIndex;
import edu.berkeley.cs.jqf.fuzz.ei.state.FastExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.NonZeroCachingCounter;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractExecutionIndexingState {
    private final int COUNTER_SIZE = 6151;
    private final int MAX_SUPPORTED_DEPTH = 1024;
    private int depth = 0;
    private int lastEventIid = -1;
    private ArrayList<Counter> stackOfCounters = new ArrayList();
    private int[] rollingIndex = new int[2048];

    public AbstractExecutionIndexingState() {
        this.stackOfCounters.add(new NonZeroCachingCounter(6151));
    }

    public AbstractExecutionIndexingState(AbstractExecutionIndexingState eis) {
        this.depth = eis.depth;
        this.lastEventIid = eis.lastEventIid;
        for (Counter c : eis.stackOfCounters) {
            this.stackOfCounters.add(new Counter(c));
        }
        System.arraycopy(eis.rollingIndex, 0, this.rollingIndex, 0, eis.rollingIndex.length);
    }

    protected void setLastEventIid(int iid) {
        this.lastEventIid = iid;
    }

    public int getLastEventIid() {
        return this.lastEventIid;
    }

    public void pushCall(int iid) {
        int count = this.stackOfCounters.get(this.depth).increment(iid);
        this.rollingIndex[2 * this.depth] = iid;
        this.rollingIndex[2 * this.depth + 1] = count;
        ++this.depth;
        if (this.depth >= 1024) {
            throw new StackOverflowError("Very deep stack; cannot compute execution index");
        }
        if (this.depth >= this.stackOfCounters.size()) {
            this.stackOfCounters.add(new NonZeroCachingCounter(6151));
        }
    }

    public void popReturn(int iid) {
        while (this instanceof FastExecutionIndexingState && this.rollingIndex[2 * (this.depth - 1)] != iid) {
            this.stackOfCounters.get(this.depth).clear();
            --this.depth;
        }
        this.stackOfCounters.get(this.depth).clear();
        --this.depth;
        assert (this.depth >= 0);
    }

    public ExecutionIndex getExecutionIndex(int iid) {
        int count = this.stackOfCounters.get(this.depth).increment(iid);
        this.rollingIndex[2 * this.depth] = iid;
        this.rollingIndex[2 * this.depth + 1] = count;
        int size = 2 * (this.depth + 1);
        int[] ei = Arrays.copyOf(this.rollingIndex, size);
        return new ExecutionIndex(ei);
    }

    public ExecutionIndex getExecutionIndex() {
        int size = 2 * this.depth;
        int[] ei = Arrays.copyOf(this.rollingIndex, size);
        return new ExecutionIndex(ei);
    }
}

