/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.guidance;

import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;

public class StreamBackedRandom
extends Random {
    private final InputStream inputStream;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(4);
    private int totalBytesRead = 0;
    private int leadingBytesToIgnore = 0;

    public StreamBackedRandom(InputStream source) {
        super(25214903917L);
        this.inputStream = source;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public StreamBackedRandom(InputStream source, int leadinBytesToIgnore) {
        this(source);
        this.leadingBytesToIgnore = leadinBytesToIgnore;
    }

    @Override
    public int next(int bits) {
        if (bits < 0 || bits > 32) {
            throw new IllegalArgumentException("Must read 1-32 bits at a time");
        }
        this.byteBuffer.putInt(0, 0);
        try {
            int maxBytesToRead = (bits + 7) / 8;
            assert (maxBytesToRead * 8 >= bits && maxBytesToRead <= 4);
            if (this.leadingBytesToIgnore > 0) {
                int bytesToIgnore = Math.min(maxBytesToRead, this.leadingBytesToIgnore);
                this.leadingBytesToIgnore -= bytesToIgnore;
                maxBytesToRead -= bytesToIgnore;
            }
            int actualBytesRead = this.inputStream.read(this.byteBuffer.array(), 0, maxBytesToRead);
            this.totalBytesRead += actualBytesRead;
            if (actualBytesRead != maxBytesToRead) {
                String message = String.format("EOF reached; total bytes read = %d, last read got %d of %d bytes", this.totalBytesRead, actualBytesRead, maxBytesToRead);
                throw new IllegalStateException(new EOFException(message));
            }
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
        int value = this.byteBuffer.getInt(0);
        int mask = bits < 32 ? (1 << bits) - 1 : -1;
        return value & mask;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return this.next(31) % bound;
    }

    public byte nextByte() {
        return (byte)this.next(8);
    }

    public short nextShort() {
        return (short)this.next(16);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRead;
    }
}

