/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.junit;

import edu.berkeley.cs.jqf.fuzz.Fuzz;
import edu.berkeley.cs.jqf.fuzz.JQF;
import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.instrument.tracing.SingleSnoop;
import edu.berkeley.cs.jqf.instrument.tracing.TraceLogger;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class GuidedFuzzing {
    private static Guidance guidance;
    public static long DEFAULT_MAX_TRIALS;

    public static synchronized void setGuidance(Guidance g) {
        if (guidance != null) {
            throw new IllegalStateException("Cannot set more than one guidance simultaneously");
        }
        guidance = g;
    }

    public static Guidance getCurrentGuidance() {
        return guidance;
    }

    public static synchronized void unsetGuidance() {
        guidance = null;
        TraceLogger.get().remove();
    }

    public static synchronized Result run(String testClassName, String testMethod, Guidance guidance, PrintStream out) throws ClassNotFoundException, IllegalStateException {
        return GuidedFuzzing.run(testClassName, testMethod, ClassLoader.getSystemClassLoader(), guidance, out);
    }

    public static synchronized Result run(String testClassName, String testMethod, ClassLoader loader, Guidance guidance, PrintStream out) throws ClassNotFoundException, IllegalStateException {
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> testClass = Class.forName(testClassName, true, loader);
        return GuidedFuzzing.run(testClass, testMethod, guidance, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Result run(Class<?> testClass, String testMethod, Guidance guidance, PrintStream out) throws IllegalStateException {
        RunWith annotation = testClass.getAnnotation(RunWith.class);
        if (annotation == null || !JQF.class.isAssignableFrom(annotation.value())) {
            throw new IllegalArgumentException(testClass.getName() + " is not annotated with @RunWith(JQF.class)");
        }
        try {
            GuidedFuzzing.setGuidance(guidance);
            SingleSnoop.setCallbackGenerator(guidance::generateCallBack);
            Request testRequest = Request.method(testClass, (String)testMethod);
            Runner testRunner = testRequest.getRunner();
            SingleSnoop.startSnooping((String)(testClass.getName() + "#" + testMethod));
            JUnitCore junit = new JUnitCore();
            if (out != null) {
                junit.addListener((RunListener)new TextListener(out));
            }
            Result result = junit.run(testRunner);
            return result;
        }
        finally {
            GuidedFuzzing.unsetGuidance();
        }
    }

    public static synchronized Result runAll(Class<?> testClass, GuidanceSupplier guidanceSupplier, PrintStream out) throws IllegalStateException, IOException {
        RunWith annotation = testClass.getAnnotation(RunWith.class);
        if (annotation == null || !JQF.class.isAssignableFrom(annotation.value())) {
            throw new IllegalArgumentException(testClass.getName() + " is not annotated with @RunWith(JQF.class)");
        }
        ArrayList<String> fuzzMethods = new ArrayList<String>();
        for (Method method : testClass.getMethods()) {
            if (!method.isAnnotationPresent(Fuzz.class)) continue;
            fuzzMethods.add(method.getName());
        }
        if (fuzzMethods.isEmpty()) {
            throw new IllegalArgumentException(testClass.getName() + " does not contain any @Fuzz methods");
        }
        Result finalResult = new Result();
        for (String methodName : fuzzMethods) {
            Guidance methodGuidance = guidanceSupplier.get(methodName);
            try {
                Result methodResult = GuidedFuzzing.run(testClass, methodName, methodGuidance, out);
                if (methodResult.wasSuccessful()) continue;
                for (Failure failure : methodResult.getFailures()) {
                    finalResult.getFailures().add(failure);
                }
            }
            catch (Exception e) {
                Failure failure;
                Description description = Description.createTestDescription(testClass, (String)methodName);
                failure = new Failure(description, (Throwable)e);
                finalResult.getFailures().add(failure);
            }
        }
        return finalResult;
    }

    static {
        DEFAULT_MAX_TRIALS = 100L;
    }

    @FunctionalInterface
    public static interface GuidanceSupplier {
        public Guidance get(String var1) throws IOException;
    }
}

