/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.random;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.fuzz.random.NoGuidance;

public class RandomDriver {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java " + String.valueOf(RandomDriver.class) + " TEST_CLASS TEST_METHOD [MAX_TRIALS]");
            System.exit(1);
        }
        String testClassName = args[0];
        String testMethodName = args[1];
        Long maxTrials = args.length > 2 ? Long.parseLong(args[2]) : Long.MAX_VALUE;
        try {
            NoGuidance guidance = new NoGuidance(maxTrials, System.err);
            GuidedFuzzing.run(testClassName, testMethodName, (Guidance)guidance, System.out);
            if (Boolean.getBoolean("jqf.logCoverage")) {
                System.out.println(String.format("Covered %d edges.", guidance.getCoverage().getNonZeroCount()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

