/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.repro;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.util.Coverage;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.function.Consumer;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;

public class ReproServerGuidance
implements Guidance {
    protected File coverageFile;
    protected BufferedReader inputFileNameReader;
    protected File inputFile;
    protected InputStream inputFileStream;
    protected Coverage coverage = new Coverage();

    public ReproServerGuidance(String inPipe, String coverageFile) throws IOException {
        this.coverageFile = new File(coverageFile);
        this.inputFileNameReader = new BufferedReader(new InputStreamReader(new FileInputStream(inPipe)));
    }

    @Override
    public boolean hasInput() {
        try {
            String inputFileName = this.inputFileNameReader.readLine();
            if (inputFileName == null) {
                throw new IOException("End of input stream");
            }
            this.inputFile = new File(inputFileName);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public InputStream getInput() throws IllegalStateException, GuidanceException {
        this.coverage.clear();
        try {
            this.inputFileStream = new BufferedInputStream(new FileInputStream(this.inputFile));
            return this.inputFileStream;
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
    }

    @Override
    public void handleResult(Result result, Throwable error) {
        try {
            if (this.inputFileStream != null) {
                this.inputFileStream.close();
            }
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
        try (PrintWriter out = new PrintWriter(this.coverageFile);){
            this.coverage.getCovered().toSortedList().forEach((IntProcedure & Serializable)i -> out.println(String.format("%05d", i)));
            out.println(result.toString());
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        return this.coverage::handleEvent;
    }
}

