/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Hashing;
import java.util.Arrays;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class Counter {
    protected final int size;
    protected final int[] counts;

    public Counter(int size) {
        this.size = size;
        this.counts = new int[size];
    }

    public Counter(Counter counter) {
        this.size = counter.size;
        this.counts = new int[this.size];
        System.arraycopy(counter.counts, 0, this.counts, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.counts, 0);
    }

    private int idx(int key) {
        return Hashing.hash(key, this.size);
    }

    private int idx1(int k1, int k2) {
        return Hashing.hash1(k1, k2, this.size);
    }

    protected int incrementAtIndex(int index, int delta) {
        int n = index;
        int n2 = this.counts[n] + delta;
        this.counts[n] = n2;
        return n2;
    }

    public int increment(int key) {
        return this.incrementAtIndex(this.idx(key), 1);
    }

    public int increment1(int k1, int k2) {
        return this.incrementAtIndex(this.idx1(k1, k2), 1);
    }

    public int increment(int key, int delta) {
        return this.incrementAtIndex(this.idx(key), delta);
    }

    public int getNonZeroSize() {
        int size = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            int count = this.counts[i];
            if (count == 0) continue;
            ++size;
        }
        return size;
    }

    public boolean hasNonZeros() {
        if (this.counts.length > 0) {
            for (int i = 0; i < this.counts.length; ++i) {
                int count = this.counts[i];
                if (count == 0) continue;
                return true;
            }
        }
        return false;
    }

    public IntList getNonZeroIndices() {
        IntArrayList indices = new IntArrayList(this.size / 2);
        for (int i = 0; i < this.counts.length; ++i) {
            int count = this.counts[i];
            if (count == 0) continue;
            indices.add(i);
        }
        return indices;
    }

    public IntList getNonZeroValues() {
        IntArrayList values = new IntArrayList(this.size / 2);
        for (int i = 0; i < this.counts.length; ++i) {
            int count = this.counts[i];
            if (count == 0) continue;
            values.add(count);
        }
        return values;
    }

    public int get(int key) {
        return this.counts[this.idx(key)];
    }

    public int getAtIndex(int idx) {
        return this.counts[idx];
    }

    public void setAtIndex(int idx, int value) {
        this.counts[idx] = value;
    }
}

