/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.ICoverage;
import edu.berkeley.cs.jqf.fuzz.util.NonZeroCachingCounter;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import java.util.Arrays;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class Coverage
implements TraceEventVisitor,
ICoverage<Counter> {
    private final int COVERAGE_MAP_SIZE = 65535;
    private final Counter counter = new NonZeroCachingCounter(65535);
    private static int[] HOB_CACHE = new int[1024];

    public Coverage copy() {
        Coverage ret = new Coverage();
        for (int idx = 0; idx < 65535; ++idx) {
            ret.counter.setAtIndex(idx, this.counter.getAtIndex(idx));
        }
        return ret;
    }

    @Override
    public int size() {
        return 65535;
    }

    public void handleEvent(TraceEvent e) {
        e.applyVisitor((TraceEventVisitor)this);
    }

    public void visitBranchEvent(BranchEvent b) {
        this.counter.increment1(b.getIid(), b.getArm());
    }

    public void visitCallEvent(CallEvent e) {
        this.counter.increment(e.getIid());
    }

    @Override
    public int getNonZeroCount() {
        return this.counter.getNonZeroSize();
    }

    @Override
    public IntList getCovered() {
        return this.counter.getNonZeroIndices();
    }

    @Override
    public IntList computeNewCoverage(ICoverage baseline) {
        IntArrayList newCoverage = new IntArrayList();
        IntList baseNonZero = this.counter.getNonZeroIndices();
        IntIterator iter = baseNonZero.intIterator();
        while (iter.hasNext()) {
            int idx = iter.next();
            if (baseline.getCounter().getAtIndex(idx) != 0) continue;
            newCoverage.add(idx);
        }
        return newCoverage;
    }

    @Override
    public void clear() {
        this.counter.clear();
    }

    private static int computeHob(int num) {
        if (num == 0) {
            return 0;
        }
        int ret = 1;
        while ((num >>= 1) != 0) {
            ret <<= 1;
        }
        return ret;
    }

    private static int hob(int num) {
        if (num < HOB_CACHE.length) {
            return HOB_CACHE[num];
        }
        return Coverage.computeHob(num);
    }

    @Override
    public boolean updateBits(ICoverage that) {
        boolean changed = false;
        if (that.getCounter().hasNonZeros()) {
            for (int idx = 0; idx < 65535; ++idx) {
                int before = this.counter.getAtIndex(idx);
                int after = before | Coverage.hob(that.getCounter().getAtIndex(idx));
                if (after == before) continue;
                this.counter.setAtIndex(idx, after);
                changed = true;
            }
        }
        return changed;
    }

    public int hashCode() {
        return Arrays.hashCode(this.counter.counts);
    }

    @Override
    public int nonZeroHashCode() {
        return this.counter.getNonZeroIndices().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Coverage counts: \n");
        for (int i = 0; i < this.counter.counts.length; ++i) {
            if (this.counter.counts[i] == 0) continue;
            sb.append(i);
            sb.append("->");
            sb.append(this.counter.counts[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public Counter getCounter() {
        return this.counter;
    }

    static {
        for (int i = 0; i < HOB_CACHE.length; ++i) {
            Coverage.HOB_CACHE[i] = Coverage.computeHob(i);
        }
    }
}

