/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.ei.state.AbstractExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.ei.state.FastExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.ei.state.JanalaExecutionIndexingState;
import edu.berkeley.cs.jqf.fuzz.util.Coverage;
import edu.berkeley.cs.jqf.fuzz.util.FastNonCollidingCoverage;
import edu.berkeley.cs.jqf.fuzz.util.ICoverage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class CoverageFactory {
    public static final String propFile = System.getProperty("janala.conf", "janala.conf");
    private static boolean FAST_NON_COLLIDING_COVERAGE_ENABLED;

    public static ICoverage newInstance() {
        if (FAST_NON_COLLIDING_COVERAGE_ENABLED) {
            return new FastNonCollidingCoverage();
        }
        return new Coverage();
    }

    public static AbstractExecutionIndexingState newEIState() {
        if (FAST_NON_COLLIDING_COVERAGE_ENABLED) {
            return new FastExecutionIndexingState();
        }
        return new JanalaExecutionIndexingState();
    }

    static {
        Properties properties = new Properties();
        try (FileInputStream propStream = new FileInputStream(propFile);){
            properties.load(propStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        FAST_NON_COLLIDING_COVERAGE_ENABLED = Boolean.parseBoolean(properties.getProperty("useFastNonCollidingCoverageInstrumentation", "false"));
    }
}

