/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;

public class FastNonCollidingCounter
extends Counter {
    IntIntHashMap counts;
    protected IntArrayList nonZeroKeys;

    public FastNonCollidingCounter(int size) {
        super(1);
        this.counts = new IntIntHashMap(size);
        this.nonZeroKeys = new IntArrayList(size / 2);
    }

    @Override
    public synchronized int size() {
        return this.counts.size();
    }

    @Override
    public synchronized void clear() {
        this.counts.clear();
        this.nonZeroKeys.clear();
    }

    @Override
    public synchronized int increment(int key) {
        int newVal = this.counts.addToValue(key, 1);
        if (newVal == 1) {
            this.nonZeroKeys.add(key);
        }
        return newVal;
    }

    @Override
    public synchronized int increment(int key, int delta) {
        int newVal = this.counts.addToValue(key, delta);
        if (newVal == delta) {
            this.nonZeroKeys.add(key);
        }
        return newVal;
    }

    @Override
    protected int incrementAtIndex(int index, int delta) {
        throw new UnsupportedOperationException("This coverage is already non-colliding, please just use get");
    }

    @Override
    public void setAtIndex(int idx, int value) {
        throw new UnsupportedOperationException("This coverage is already non-colliding, please just use setAtIndex");
    }

    @Override
    public int getAtIndex(int idx) {
        throw new UnsupportedOperationException("This coverage is already non-colliding, please just use set");
    }

    @Override
    public synchronized int getNonZeroSize() {
        return this.nonZeroKeys.size();
    }

    public synchronized IntList getNonZeroKeys() {
        return this.nonZeroKeys;
    }

    @Override
    public IntList getNonZeroIndices() {
        return this.getNonZeroKeys();
    }

    @Override
    public synchronized IntList getNonZeroValues() {
        IntArrayList values = new IntArrayList(this.counts.size() / 2);
        MutableIntIterator iter = this.counts.values().intIterator();
        while (iter.hasNext()) {
            int val = iter.next();
            if (val == 0) continue;
            values.add(val);
        }
        return values;
    }

    @Override
    public synchronized int get(int key) {
        return this.counts.get(key);
    }

    public synchronized void copyFrom(FastNonCollidingCounter counter) {
        this.counts = new IntIntHashMap((IntIntMap)counter.counts);
        this.nonZeroKeys = new IntArrayList(counter.nonZeroKeys.size());
        this.nonZeroKeys.addAll((IntIterable)counter.nonZeroKeys);
    }

    @Override
    public boolean hasNonZeros() {
        return !this.nonZeroKeys.isEmpty();
    }
}

