/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.FastNonCollidingCounter;
import edu.berkeley.cs.jqf.fuzz.util.ICoverage;
import janala.instrument.FastCoverageListener;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class FastNonCollidingCoverage
extends FastCoverageListener.Default
implements ICoverage<FastNonCollidingCounter> {
    private final int COVERAGE_MAP_SIZE = 256;
    private final FastNonCollidingCounter counter = new FastNonCollidingCounter(256);
    private static int[] HOB_CACHE = new int[1024];

    public FastNonCollidingCoverage copy() {
        FastNonCollidingCoverage ret = new FastNonCollidingCoverage();
        ret.counter.copyFrom(this.counter);
        return ret;
    }

    @Override
    public int size() {
        return 256;
    }

    @Override
    public int getNonZeroCount() {
        return this.counter.getNonZeroSize();
    }

    @Override
    public IntList getCovered() {
        return this.counter.getNonZeroIndices();
    }

    @Override
    public IntList computeNewCoverage(ICoverage baseline) {
        IntArrayList newCoverage = new IntArrayList();
        IntList baseNonZero = this.counter.getNonZeroKeys();
        IntIterator iter = baseNonZero.intIterator();
        while (iter.hasNext()) {
            int idx = iter.next();
            if (baseline.getCounter().get(idx) != 0) continue;
            newCoverage.add(idx);
        }
        return newCoverage;
    }

    @Override
    public void clear() {
        this.counter.clear();
    }

    private static int computeHob(int num) {
        if (num == 0) {
            return 0;
        }
        int ret = 1;
        while ((num >>= 1) != 0) {
            ret <<= 1;
        }
        return ret;
    }

    private static int hob(int num) {
        if (num < HOB_CACHE.length) {
            return HOB_CACHE[num];
        }
        return FastNonCollidingCoverage.computeHob(num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBits(ICoverage that) {
        boolean changed = false;
        FastNonCollidingCounter fastNonCollidingCounter = this.counter;
        synchronized (fastNonCollidingCounter) {
            Counter counter = that.getCounter();
            synchronized (counter) {
                FastNonCollidingCounter thatCounter = (FastNonCollidingCounter)that.getCounter();
                for (IntIntPair coverageEntry : thatCounter.counts.keyValuesView()) {
                    int before = this.counter.counts.get(coverageEntry.getOne());
                    int after = before | FastNonCollidingCoverage.hob(coverageEntry.getTwo());
                    if (after != before) {
                        this.counter.counts.put(coverageEntry.getOne(), after);
                        changed = true;
                    }
                    if (before != 0) continue;
                    this.counter.nonZeroKeys.add(coverageEntry.getOne());
                }
            }
        }
        return changed;
    }

    public int hashCode() {
        return this.counter.counts.hashCode();
    }

    @Override
    public int nonZeroHashCode() {
        return this.counter.getNonZeroIndices().hashCode();
    }

    @Override
    public Counter getCounter() {
        return this.counter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Coverage counts: \n");
        for (int i = 0; i < this.counter.counts.size(); ++i) {
            if (this.counter.counts.get(i) == 0) continue;
            sb.append(i);
            sb.append("->");
            sb.append(this.counter.counts.get(i));
            sb.append('\n');
        }
        return sb.toString();
    }

    public void logMethodBegin(int iid) {
        this.logCoverage(iid, 0);
    }

    public void logJump(int iid, int branch) {
        this.logCoverage(iid, branch);
    }

    public void logLookUpSwitch(int value, int iid, int dflt, int[] cases) {
        int arm = cases.length;
        for (int i = 0; i < cases.length; ++i) {
            if (value != cases[i]) continue;
            arm = i;
            break;
        }
        this.logCoverage(iid, ++arm);
    }

    public void logTableSwitch(int value, int iid, int min, int max, int dflt) {
        int arm = 1 + max - min;
        if (value >= min && value <= max) {
            arm = value - min;
        }
        this.logCoverage(iid, ++arm);
    }

    private void logCoverage(int iid, int arm) {
        this.counter.increment(iid + arm);
    }

    static {
        for (int i = 0; i < HOB_CACHE.length; ++i) {
            FastNonCollidingCoverage.HOB_CACHE[i] = FastNonCollidingCoverage.computeHob(i);
        }
    }
}

