/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.Hashing;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class MapOfCounters {
    private final int numCounters;
    private final int counterSize;
    private final Counter[] counters;

    public MapOfCounters(int numCounters, int counterSize) {
        this.numCounters = numCounters;
        this.counterSize = counterSize;
        this.counters = new Counter[numCounters];
    }

    public void clear() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = null;
        }
    }

    private int idx(int key) {
        return Hashing.hash(key, this.numCounters);
    }

    public void increment(int k1, int k2) {
        int idx = this.idx(k1);
        if (this.counters[idx] == null) {
            this.counters[idx] = new Counter(this.counterSize);
        }
        this.counters[idx].increment(k2);
    }

    public IntList nonZeroCountsAtIndex(int idx) {
        if (this.counters[idx] != null) {
            return this.counters[idx].getNonZeroValues();
        }
        return new IntArrayList(0);
    }

    public Collection<Integer> nonEmptyCountersIndices() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.numCounters);
        for (int i = 0; i < this.numCounters; ++i) {
            if (this.counters[i] == null) continue;
            keys.add(i);
        }
        return keys;
    }
}

