/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class NonZeroCachingCounter
extends Counter {
    private int nonZeroCount = 0;
    private IntArrayList nonZeroIndices = new IntArrayList();

    public NonZeroCachingCounter(int size) {
        super(size);
    }

    @Override
    public void clear() {
        MutableIntIterator iter = this.nonZeroIndices.intIterator();
        while (iter.hasNext()) {
            int idx = iter.next();
            this.counts[idx] = 0;
        }
        this.nonZeroCount = 0;
        this.nonZeroIndices = new IntArrayList();
    }

    @Override
    public int incrementAtIndex(int index, int delta) {
        int newValue = super.incrementAtIndex(index, delta);
        if (newValue == delta) {
            this.nonZeroIndices.add(index);
            ++this.nonZeroCount;
        }
        return newValue;
    }

    @Override
    public int getNonZeroSize() {
        return this.nonZeroCount;
    }

    @Override
    public boolean hasNonZeros() {
        return this.nonZeroCount > 0;
    }

    @Override
    public IntList getNonZeroIndices() {
        return this.nonZeroIndices;
    }

    @Override
    public IntList getNonZeroValues() {
        IntArrayList values = new IntArrayList(this.size / 2);
        MutableIntIterator iter = this.nonZeroIndices.intIterator();
        while (iter.hasNext()) {
            int idx = iter.next();
            int count = this.counts[idx];
            assert (count != 0);
            values.add(count);
        }
        return values;
    }

    @Override
    public void setAtIndex(int index, int newValue) {
        int oldValue = this.counts[index];
        super.setAtIndex(index, newValue);
        if (oldValue == 0 && newValue != 0) {
            this.nonZeroIndices.add(index);
            ++this.nonZeroCount;
        }
    }
}

