/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument;

import janala.instrument.SnoopInstructionTransformer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class InstrumentingClassLoader
extends URLClassLoader {
    private ClassFileTransformer transformer = new SnoopInstructionTransformer();

    public InstrumentingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public InstrumentingClassLoader(String[] paths, ClassLoader parent) throws MalformedURLException {
        this(InstrumentingClassLoader.stringsToUrls(paths), parent);
    }

    public static URL[] stringsToUrls(String[] paths) throws MalformedURLException {
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        return urls;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] transformedBytes;
        byte[] bytes;
        String internalName = name.replace('.', '/');
        String path = internalName.concat(".class");
        try (InputStream in = super.getResourceAsStream(path);){
            int b;
            if (in == null) {
                throw new ClassNotFoundException("Cannot find class " + name);
            }
            BufferedInputStream buf = new BufferedInputStream(in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = buf.read()) != -1) {
                baos.write(b);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException("I/O exception while loading class.", e);
        }
        assert (bytes != null);
        try {
            transformedBytes = this.transformer.transform(this, internalName, null, null, bytes);
        }
        catch (IllegalClassFormatException e) {
            transformedBytes = null;
        }
        if (transformedBytes != null) {
            bytes = transformedBytes;
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

