/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.tracing.events;

import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import janala.logger.inst.MemberRef;

public abstract class TraceEvent {
    protected final int iid;
    protected final MemberRef containingMethod;
    protected final int lineNumber;

    public TraceEvent(int iid, MemberRef method, int lineNumber) {
        this.iid = iid;
        this.containingMethod = method;
        this.lineNumber = lineNumber;
    }

    public int getIid() {
        return this.iid;
    }

    public String getFileName() {
        if (this.containingMethod == null) {
            return "<unknown>";
        }
        String owner = this.containingMethod.getOwner();
        int idxOfDollar = owner.indexOf(36);
        if (idxOfDollar >= 0) {
            return owner.substring(0, idxOfDollar) + ".java";
        }
        return owner + ".java";
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getContainingClass() {
        if (this.containingMethod == null) {
            return "";
        }
        return this.containingMethod.getOwner();
    }

    public String getContainingMethodName() {
        if (this.containingMethod == null) {
            return "<unknown>";
        }
        return this.containingMethod.getName();
    }

    public String getContainingMethodDesc() {
        if (this.containingMethod == null) {
            return "(?)";
        }
        return this.containingMethod.getDesc();
    }

    public abstract void applyVisitor(TraceEventVisitor var1);
}

