/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

class Config {
    public static final String propFile = System.getProperty("janala.conf", "janala.conf");
    public static final Config instance = new Config();
    public final boolean verbose;
    public final String analysisClass;
    public final String[] excludeInst;
    public final String[] includeInst;
    public final boolean instrumentHeapLoad;
    public final boolean instrumentAlloc;
    public final String instrumentationCacheDir;

    private Config() {
        Properties properties = new Properties();
        try (FileInputStream propStream2 = new FileInputStream(propFile);){
            properties.load(propStream2);
        }
        catch (IOException propStream2) {
            // empty catch block
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        this.verbose = Boolean.parseBoolean(properties.getProperty("janala.verbose", "false"));
        this.analysisClass = properties.getProperty("janala.snoopClass", "edu.berkeley.cs.jqf.instrument.tracing.SingleSnoop").replace('.', '/');
        this.instrumentHeapLoad = Boolean.parseBoolean(properties.getProperty("janala.instrumentHeapLoad", "false"));
        this.instrumentAlloc = Boolean.parseBoolean(properties.getProperty("janala.instrumentAlloc", "false"));
        String excludeInstStr = properties.getProperty("janala.excludes", "");
        this.excludeInst = excludeInstStr.length() > 0 ? excludeInstStr.replace('.', '/').split(",") : new String[0];
        String includeInstStr = properties.getProperty("janala.includes", "");
        this.includeInst = includeInstStr.length() > 0 ? includeInstStr.replace('.', '/').split(",") : new String[0];
        this.instrumentationCacheDir = properties.getProperty("janala.instrumentationCacheDir");
    }
}

