/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

public class GlobalStateForInstrumentation {
    public static GlobalStateForInstrumentation instance = new GlobalStateForInstrumentation();
    private int iid = 0;
    private int mid = 0;
    private int cid = 0;
    private static final int CBITS = 10;
    private static final int MBITS = 10;
    private static final int IBITS = 12;

    public int incAndGetId() {
        ++this.iid;
        this.validate(this.iid, 12);
        return this.getId();
    }

    public int getId() {
        return (this.cid << 22) + (this.mid << 12) + this.iid;
    }

    public int getMid() {
        return this.mid;
    }

    public void incMid() {
        ++this.mid;
        this.validate(this.mid, 10);
        this.iid = 0;
    }

    public int getCid() {
        return this.cid;
    }

    public void setCid(int cid) {
        cid = Math.abs(cid) % 1024;
        this.iid = 0;
        this.mid = 0;
        this.cid = cid;
    }

    private void validate(int id, int bits) {
        if (id < 0 || id >= 1 << bits) {
            throw new IllegalArgumentException("Invalid instruction ID range");
        }
    }
}

