/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import janala.instrument.Config;
import janala.instrument.GlobalStateForInstrumentation;
import janala.instrument.SafeClassWriter;
import janala.instrument.SnoopInstructionClassAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class SnoopInstructionTransformer
implements ClassFileTransformer {
    private static final String instDir = Config.instance.instrumentationCacheDir;
    private static final boolean verbose = Config.instance.verbose;
    private static String[] banned = new String[]{"[", "java/lang", "janala", "org/objectweb/asm", "sun", "jdk", "java/util/function"};
    private static String[] excludes = Config.instance.excludeInst;
    private static String[] includes = Config.instance.includeInst;
    static Map<String, byte[]> instrumentedBytes = new TreeMap<String, byte[]>();

    public static void premain(String agentArgs, Instrumentation inst) throws ClassNotFoundException {
        SnoopInstructionTransformer.preloadClasses();
        inst.addTransformer(new SnoopInstructionTransformer(), true);
        if (inst.isRetransformClassesSupported()) {
            for (Class clazz : inst.getAllLoadedClasses()) {
                try {
                    String cname = clazz.getName().replace(".", "/");
                    if (SnoopInstructionTransformer.shouldExclude(cname)) continue;
                    if (inst.isModifiableClass(clazz)) {
                        inst.retransformClasses(clazz);
                        continue;
                    }
                    SnoopInstructionTransformer.println("[WARNING] Could not instrument " + clazz);
                }
                catch (Exception e) {
                    if (!verbose) continue;
                    SnoopInstructionTransformer.println("[WARNING] Could not instrument " + clazz);
                    e.printStackTrace();
                }
            }
        }
    }

    private static void preloadClasses() throws ClassNotFoundException {
        Class.forName("java.util.ArrayDeque");
        Class.forName("java.util.LinkedList");
        Class.forName("java.util.LinkedList$Node");
        Class.forName("java.util.LinkedList$ListItr");
        Class.forName("java.util.TreeMap");
        Class.forName("java.util.TreeMap$Entry");
        Class.forName("java.util.zip.ZipFile");
        Class.forName("java.util.jar.JarFile");
    }

    private static boolean shouldExclude(String cname) {
        for (String e : banned) {
            if (!cname.startsWith(e)) continue;
            return true;
        }
        for (String e : includes) {
            if (!cname.startsWith(e)) continue;
            return false;
        }
        for (String e : excludes) {
            if (!cname.startsWith(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized byte[] transform(ClassLoader loader, String cname, Class<?> classBeingRedefined, ProtectionDomain d, byte[] cbuf) throws IllegalClassFormatException {
        boolean toInstrument;
        if (cname == null) {
            return null;
        }
        boolean bl = toInstrument = !SnoopInstructionTransformer.shouldExclude(cname);
        if (toInstrument) {
            SnoopInstructionTransformer.print("[INFO] ");
            if (classBeingRedefined != null) {
                SnoopInstructionTransformer.print("* ");
            }
            SnoopInstructionTransformer.print("Instrumenting: " + cname + "... ");
            GlobalStateForInstrumentation.instance.setCid(cname.hashCode());
            if (instrumentedBytes.containsKey(cname)) {
                SnoopInstructionTransformer.println(" Found in fast-cache!");
                return instrumentedBytes.get(cname);
            }
            if (instDir != null) {
                File cachedFile = new File(instDir + "/" + cname + ".instrumented.class");
                File referenceFile = new File(instDir + "/" + cname + ".original.class");
                if (cachedFile.exists() && referenceFile.exists()) {
                    try {
                        byte[] origBytes = Files.readAllBytes(referenceFile.toPath());
                        if (Arrays.equals(cbuf, origBytes)) {
                            byte[] instBytes = Files.readAllBytes(cachedFile.toPath());
                            SnoopInstructionTransformer.println(" Found in disk-cache!");
                            instrumentedBytes.put(cname, instBytes);
                            return instBytes;
                        }
                    }
                    catch (IOException e) {
                        SnoopInstructionTransformer.print(" <cache error> ");
                    }
                }
            }
            byte[] ret = cbuf;
            try {
                ClassReader cr = new ClassReader(cbuf);
                SafeClassWriter cw = new SafeClassWriter(cr, loader, 3);
                SnoopInstructionClassAdapter cv = new SnoopInstructionClassAdapter((ClassVisitor)cw, cname);
                cr.accept((ClassVisitor)cv, 0);
                ret = cw.toByteArray();
            }
            catch (Throwable e) {
                SnoopInstructionTransformer.println("\n[WARNING] Could not instrument " + cname);
                if (verbose) {
                    e.printStackTrace();
                }
                return null;
            }
            SnoopInstructionTransformer.println("Done!");
            instrumentedBytes.put(cname, ret);
            if (instDir != null) {
                try {
                    File cachedFile = new File(instDir + "/" + cname + ".instrumented.class");
                    File referenceFile = new File(instDir + "/" + cname + ".original.class");
                    File parent = new File(cachedFile.getParent());
                    parent.mkdirs();
                    try (FileOutputStream out = new FileOutputStream(cachedFile);){
                        out.write(ret);
                    }
                    out = new FileOutputStream(referenceFile);
                    try {
                        out.write(cbuf);
                    }
                    finally {
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return cbuf;
    }

    private static void print(String str) {
        if (verbose) {
            System.out.print(str);
        }
    }

    private static void println(String line) {
        if (verbose) {
            System.out.println(line);
        }
    }
}

