/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import janala.instrument.Config;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class Utils
implements Opcodes {
    public static void addBipushInsn(MethodVisitor mv, int val) {
        switch (val) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitLdcInsn((Object)val);
            }
        }
    }

    public static void addSpecialInsn(MethodVisitor mv, int val) {
        Utils.addBipushInsn(mv, val);
        mv.visitMethodInsn(184, Config.instance.analysisClass, "SPECIAL", "(I)V", false);
    }

    public static void addValueReadInsn(MethodVisitor mv, String desc, String methodNamePrefix) {
        Type t = desc.startsWith("(") ? Type.getReturnType((String)desc) : Type.getType((String)desc);
        switch (t.getSort()) {
            case 8: {
                mv.visitInsn(92);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "double", "(D)V", false);
                break;
            }
            case 7: {
                mv.visitInsn(92);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "long", "(J)V", false);
                break;
            }
            case 9: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "Object", "(Ljava/lang/Object;)V", false);
                break;
            }
            case 1: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "boolean", "(Z)V", false);
                break;
            }
            case 3: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "byte", "(B)V", false);
                break;
            }
            case 2: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "char", "(C)V", false);
                break;
            }
            case 6: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "float", "(F)V", false);
                break;
            }
            case 5: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "int", "(I)V", false);
                break;
            }
            case 10: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "Object", "(Ljava/lang/Object;)V", false);
                break;
            }
            case 4: {
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "short", "(S)V", false);
                break;
            }
            case 0: {
                mv.visitMethodInsn(184, Config.instance.analysisClass, methodNamePrefix + "void", "()V", false);
                break;
            }
            default: {
                System.err.println("Unknown field or method descriptor " + desc);
                System.exit(1);
            }
        }
    }
}

